/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.server.runner.parameterized;

import java.util.List;
import org.eclipse.scout.rt.testing.server.runner.ScoutServerTestRunner;
import org.eclipse.scout.rt.testing.shared.runner.parameterized.IScoutTestParameter;
import org.eclipse.scout.rt.testing.shared.runner.parameterized.ParameterizedFrameworkMethod;
import org.eclipse.scout.rt.testing.shared.runner.parameterized.ParameterizedTestRunnerExtension;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class ParameterizedScoutServerTestRunner
extends ScoutServerTestRunner {
    private List<IScoutTestParameter> m_parameterList;
    private IScoutTestParameter m_currentTestParameter = null;

    public ParameterizedScoutServerTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected List<FrameworkMethod> getChildren() {
        this.m_parameterList = ParameterizedTestRunnerExtension.loadParameterList((TestClass)this.getTestClass());
        return ParameterizedTestRunnerExtension.createTestMethods((List)super.getChildren(), (int)this.m_parameterList.size());
    }

    protected final Object createTest() throws Exception {
        return this.createTestInternal(this.m_currentTestParameter);
    }

    protected Object createTestInternal(IScoutTestParameter testParameter) throws Exception {
        return ParameterizedTestRunnerExtension.createTest((TestClass)this.getTestClass(), (IScoutTestParameter)testParameter);
    }

    @Override
    protected Statement methodBlock(FrameworkMethod method) {
        if (method instanceof ParameterizedFrameworkMethod) {
            int paramsIndex = ((ParameterizedFrameworkMethod)method).getParamIndex();
            this.m_currentTestParameter = this.m_parameterList.get(paramsIndex);
        } else {
            this.m_currentTestParameter = null;
        }
        return super.methodBlock(method);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        this.validateParametersMethod(errors);
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
    }

    protected void validateParametersMethod(List<Throwable> errors) {
        ParameterizedTestRunnerExtension.validateOneParametersMethod((TestClass)this.getTestClass(), errors);
    }

    protected Description describeChild(FrameworkMethod method) {
        if (method instanceof ParameterizedFrameworkMethod) {
            return ParameterizedTestRunnerExtension.describeParameterizedChild((TestClass)this.getTestClass(), (ParameterizedFrameworkMethod)((ParameterizedFrameworkMethod)method), (String)this.testName(method), this.m_parameterList);
        }
        return super.describeChild(method);
    }
}

