/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Locale;
import javax.security.auth.Subject;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.scout.commons.LocaleUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.prefs.UserScope;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.exceptionhandler.ErrorHandler;
import org.eclipse.scout.rt.client.services.common.exceptionhandler.UserInterruptedException;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.job.SwingProgressHandler;
import org.eclipse.scout.rt.ui.swing.splash.SplashProgressMonitor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

abstract class BaseSwingApplication
implements IApplication {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BaseSwingApplication.class);
    private SplashProgressMonitor m_monitor;
    private ServiceRegistration m_monitorReg;

    BaseSwingApplication() {
    }

    void initialize() {
        if (!Platform.inDevelopmentMode()) {
            try {
                URL instArea = Platform.getInstanceLocation().getURL();
                File sysoutRedirector = new File(instArea.getFile(), String.valueOf(System.getProperty("user.name", "anonymous")) + "-sysout.log");
                File syserrRedirector = new File(instArea.getFile(), String.valueOf(System.getProperty("user.name", "anonymous")) + "-syserr.log");
                sysoutRedirector.getParentFile().mkdirs();
                syserrRedirector.getParentFile().mkdirs();
                System.setOut(new PrintStream(new FileOutputStream(sysoutRedirector, true)));
                System.setErr(new PrintStream(new FileOutputStream(syserrRedirector, true)));
            }
            catch (Throwable instArea) {
                // empty catch block
            }
        }
        try {
            this.execInitLocale();
            SwingProgressHandler.install();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BaseSwingApplication.this.initializeSwing();
                }
            });
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
            System.exit(0);
        }
        this.m_monitor = new SplashProgressMonitor(this.getSwingEnvironment(), this.showSplashScreenProgressInPercentage());
        if (Platform.getProduct() != null && Platform.getProduct().getDefiningBundle() != null) {
            BundleContext ctx = Platform.getProduct().getDefiningBundle().getBundleContext();
            this.m_monitorReg = ctx.registerService(IProgressMonitor.class.getName(), (Object)this.m_monitor, new Hashtable());
        }
        this.m_monitor.showSplash();
    }

    abstract void initializeSwing();

    abstract ISwingEnvironment getSwingEnvironment();

    protected boolean showSplashScreenProgressInPercentage() {
        return false;
    }

    public final IProgressMonitor getProgressMonitor() {
        return this.m_monitor;
    }

    public Object start(final IApplicationContext context) throws Exception {
        if (Subject.getSubject(AccessController.getContext()) != null) {
            return this.exit(this.startInSubject(context));
        }
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal(System.getProperty("user.name")));
        return Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                return BaseSwingApplication.this.exit(BaseSwingApplication.this.startInSubject(context));
            }
        });
    }

    abstract Object startInSubject(IApplicationContext var1) throws Exception;

    protected Object exit(Object code) {
        if ("macosx".equals(Platform.getOS())) {
            System.exit(0);
        }
        return code;
    }

    protected void execInitLocale() {
        Locale locale = LocaleUtility.parse((String)new UserScope().getNode("org.eclipse.scout.rt.client").get("locale", null));
        if (locale != null) {
            Locale.setDefault(locale);
        }
    }

    protected UserAgent initUserAgent() {
        return UserAgent.create((IUiLayer)UiLayer.SWING, (IUiDeviceType)UiDeviceType.DESKTOP);
    }

    boolean isClientSessionValid(IClientSession clientSession) {
        if (clientSession.isActive()) {
            return true;
        }
        this.showLoadError(clientSession.getLoadError());
        return false;
    }

    protected void stopSplashScreen() {
        if (this.m_monitorReg != null) {
            this.m_monitorReg.unregister();
        }
        this.m_monitor.done();
        this.m_monitor = null;
    }

    protected void showLoadError(Throwable error) {
        ErrorHandler handler = new ErrorHandler(error);
        if (handler.getText().indexOf(UserInterruptedException.class.getSimpleName()) < 0) {
            SwingUtility.showMessageDialogSynthCapable(null, StringUtility.join((String)"\n\n", (Object[])new Object[]{handler.getText(), handler.getDetail()}), handler.getTitle(), 0);
        }
    }
}

