/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.TextBlockDragAndDrop;
import org.eclipse.scout.rt.ui.swing.UndoableEditObserver;
import org.eclipse.scout.rt.ui.swing.form.fields.OnFieldLabelDecorator;

public class JTextFieldEx
extends JTextField {
    private static final long serialVersionUID = 1L;
    private OnFieldLabelDecorator m_onFieldLabelHandler;

    public JTextFieldEx() {
        SwingUtility.installDefaultFocusHandling(this);
        TextBlockDragAndDrop.attach(this);
        UndoableEditObserver.attach(this);
        SwingUtility.installAlternateCopyPaste(this);
    }

    public JTextFieldEx(int n) {
        super(n);
        SwingUtility.installDefaultFocusHandling(this);
        TextBlockDragAndDrop.attach(this);
        UndoableEditObserver.attach(this);
        SwingUtility.installAlternateCopyPaste(this);
    }

    @Override
    public Color getForeground() {
        if (this.isEditable()) {
            return super.getForeground();
        }
        return this.getDisabledTextColor();
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (cursor != null && cursor.getType() == 0) {
            cursor = null;
        }
        super.setCursor(cursor);
    }

    public void setOnFieldLabelHandler(OnFieldLabelDecorator onFieldLabelHandler) {
        this.m_onFieldLabelHandler = onFieldLabelHandler;
        this.repaint();
    }

    public OnFieldLabelDecorator getOnFieldLabelHandler() {
        return this.m_onFieldLabelHandler;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_onFieldLabelHandler != null) {
            this.m_onFieldLabelHandler.paintOnFieldLabel(g, this);
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }
}

