/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JViewport;
import javax.swing.ViewportLayout;
import org.eclipse.scout.rt.ui.swing.ext.JScrollPaneEx;

public class ViewportTrackableJScrollPaneEx
extends JScrollPaneEx {
    private static final long serialVersionUID = 1L;

    public ViewportTrackableJScrollPaneEx(Component view) {
        super(view, 20, 30);
    }

    @Override
    protected JViewport createViewport() {
        return new P_Viewport();
    }

    private class P_Viewport
    extends JViewport {
        private static final long serialVersionUID = 1L;

        private P_Viewport() {
        }

        @Override
        protected LayoutManager createLayoutManager() {
            return new P_ViewportLayout();
        }
    }

    private class P_ViewportLayout
    extends ViewportLayout {
        private static final long serialVersionUID = 1L;
        private int m_defaultHScrollPolicy;
        private int m_defaultVScrollPolicy;

        private P_ViewportLayout() {
            this.m_defaultHScrollPolicy = ViewportTrackableJScrollPaneEx.this.getHorizontalScrollBarPolicy();
            this.m_defaultVScrollPolicy = ViewportTrackableJScrollPaneEx.this.getVerticalScrollBarPolicy();
        }

        @Override
        public void layoutContainer(Container parent) {
            JViewport vp = (JViewport)parent;
            Component view = vp.getView();
            if (view == null) {
                return;
            }
            Point viewPosition = vp.getViewPosition();
            Dimension viewPrefSize = view.getPreferredSize();
            Dimension viewMinSize = view.getMinimumSize();
            Dimension vpSize = vp.getSize();
            Dimension viewSize = new Dimension(viewPrefSize);
            if (viewPosition.x == 0 && vpSize.width > viewMinSize.width) {
                viewSize.width = vpSize.width;
                ViewportTrackableJScrollPaneEx.this.setHorizontalScrollBarPolicy(31);
            } else {
                ViewportTrackableJScrollPaneEx.this.setHorizontalScrollBarPolicy(this.m_defaultHScrollPolicy);
            }
            if (viewPosition.y == 0 && vpSize.height > viewMinSize.height) {
                ViewportTrackableJScrollPaneEx.this.setVerticalScrollBarPolicy(21);
                viewSize.height = vpSize.height;
            } else {
                ViewportTrackableJScrollPaneEx.this.setVerticalScrollBarPolicy(this.m_defaultVScrollPolicy);
            }
            viewSize.width = Math.max(viewMinSize.width, viewSize.width);
            viewSize.height = Math.max(viewMinSize.height, viewSize.height);
            vp.setViewPosition(viewPosition);
            vp.setViewSize(viewSize);
        }
    }
}

