/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.activitymap;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityComponent;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.JActivityMap;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.JSelector;

public class ActivityMapLayout
implements LayoutManager2 {
    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(20, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            JActivityMap map = (JActivityMap)parent;
            int rowCount = map.getRowCount();
            Rectangle r = map.getCellRect(0, rowCount - 1, new double[]{0.0, 1.0});
            r.width = 800;
            return new Dimension(r.width, r.height);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(10240, 10240);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            JActivityMap map = (JActivityMap)parent;
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c.isVisible()) {
                    Rectangle r;
                    if (c instanceof JSelector) {
                        double[] range = map.getSelectedRange();
                        if (range != null) {
                            r = map.getRect(map.getSelectedRange());
                            r.y = 0;
                            r.height = parent.getHeight();
                            c.setBounds(r);
                        } else {
                            c.setBounds(-1, -1, 0, 0);
                        }
                    } else if (c instanceof ActivityComponent) {
                        ActivityComponent a = (ActivityComponent)((Object)c);
                        r = map.getCellRect(a.getRowIndex(), a.getRowIndex(), map.getModel().getActivityRange(a));
                        c.setBounds(r);
                    } else {
                        c.setBounds(-1, -1, 0, 0);
                        System.out.println("Unexpected component on JActivityMap: " + c);
                    }
                }
                ++n2;
            }
        }
    }
}

