/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.activitymap;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputListener;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityComponent;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapColumnModel;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapLayout;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapModel;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapSelection;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapSelectionEvent;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapSelectionListener;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.JActivityMapHeader;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.JSelector;

public class JActivityMap
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = 1L;
    private EventListenerList m_listeners = new EventListenerList();
    private ActivityMapModel m_model;
    private ActivityMapColumnModel m_columnModel;
    private JActivityMapHeader m_header = new JActivityMapHeader(this);
    private JSelector m_selector;
    private ActivityMapSelection m_selection;
    private MouseInputListener m_activityProxyMouseListener;
    private FocusListener m_activityProxyFocusListener;
    private JViewport m_viewport;
    private boolean m_pressedInsideMap;
    private int m_selectorResizeType = 0;
    private IActivityMap<?, ?> m_scoutActivityMap;
    private int m_rowStartedDrag;
    private int m_currentRowDrag;

    public JActivityMap() {
        this.setBackground(Color.white);
        this.m_selection = new ActivityMapSelection();
        this.m_selector = new JSelector(this);
        this.m_selector.addMouseListener(new MouseAdapter(){
            MouseClickedBugFix fix;

            @Override
            public void mousePressed(MouseEvent e) {
                this.fix = new MouseClickedBugFix(e);
                Component parent = JActivityMap.getParentAt(e.getComponent(), e.getPoint());
                e = SwingUtilities.convertMouseEvent(e.getComponent(), e, parent);
                if (parent != null) {
                    parent.dispatchEvent(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Component parent = JActivityMap.getParentAt(e.getComponent(), e.getPoint());
                if (parent != null) {
                    parent.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, parent));
                    if (this.fix != null) {
                        this.fix.mouseReleased(this, e);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.fix.mouseClicked()) {
                    return;
                }
                Component parent = JActivityMap.getParentAt(e.getComponent(), e.getPoint());
                if (parent != null) {
                    parent.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, parent));
                }
            }
        });
        this.m_selector.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Component parent = JActivityMap.getParentAt(e.getComponent(), e.getPoint());
                if (parent != null) {
                    parent.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, parent));
                }
            }
        });
        this.setLayout(new ActivityMapLayout());
        this.add(this.m_selector);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JActivityMap.this.m_pressedInsideMap = false;
                if (JActivityMap.isButton1(e)) {
                    JActivityMap.this.m_pressedInsideMap = true;
                    ActivityMapSelection s = new ActivityMapSelection(JActivityMap.this.m_selection);
                    int row = JActivityMap.this.pixToRow(e.getY());
                    JActivityMap.this.m_rowStartedDrag = row;
                    double[] mouseRange = JActivityMap.this.pixToRange(e.getX());
                    if (JActivityMap.this.m_selection.getRange() != null && JActivityMap.this.m_selector.getCursor().getType() == 11) {
                        JActivityMap.this.m_selectorResizeType = JActivityMap.this.m_selector.getCursor().getType();
                        s.clear();
                        s.setRows(JActivityMap.this.m_selection.getRows());
                        s.setRange(new double[]{JActivityMap.this.m_selection.getRange()[0], mouseRange[1]});
                    } else if (JActivityMap.this.m_selection.getRange() != null && JActivityMap.this.m_selector.getCursor().getType() == 10) {
                        JActivityMap.this.m_selectorResizeType = JActivityMap.this.m_selector.getCursor().getType();
                        s.clear();
                        s.setRows(JActivityMap.this.m_selection.getRows());
                        s.setRange(new double[]{mouseRange[0], JActivityMap.this.m_selection.getRange()[1]});
                    } else if (e.isShiftDown()) {
                        if (!s.hasAnchor()) {
                            s.setAnchor(row, mouseRange);
                        }
                        s.setLead(row, mouseRange);
                    } else if (e.isControlDown()) {
                        s.setAnchor(row, mouseRange);
                        s.setLead(row, mouseRange);
                    } else {
                        s.clear();
                        s.setAnchor(row, mouseRange);
                        s.setLead(row, mouseRange);
                    }
                    JActivityMap.this.setSelectionInternal(s);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (JActivityMap.isButton1(e) && JActivityMap.this.m_pressedInsideMap) {
                    ActivityMapSelection s = new ActivityMapSelection(JActivityMap.this.m_selection);
                    int row = JActivityMap.this.pixToRow(e.getY());
                    double[] mouseRange = JActivityMap.this.pixToRange(e.getX());
                    s.consumeAnchorLead();
                    s.setAnchor(row, mouseRange);
                    JActivityMap.this.setSelectionInternal(s);
                }
                JActivityMap.this.m_selectorResizeType = 0;
                JActivityMap.this.m_pressedInsideMap = false;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (JActivityMap.isButton1(e) && JActivityMap.this.m_pressedInsideMap) {
                    ActivityMapSelection s = new ActivityMapSelection(JActivityMap.this.m_selection);
                    int row = JActivityMap.this.pixToRow(e.getY());
                    double[] mouseRange = JActivityMap.this.pixToRange(e.getX());
                    if (JActivityMap.this.m_selectorResizeType == 11) {
                        s.setRange(new double[]{JActivityMap.this.m_selection.getRange()[0], mouseRange[1]});
                    } else if (JActivityMap.this.m_selectorResizeType == 10) {
                        s.setRange(new double[]{mouseRange[0], JActivityMap.this.m_selection.getRange()[1]});
                    } else if (!s.hasAnchor()) {
                        s.setAnchor(row, mouseRange);
                        s.setLead(row, mouseRange);
                    }
                    JActivityMap.this.setSelectionInternal(s);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (JActivityMap.isButton1(e) && JActivityMap.this.m_pressedInsideMap) {
                    ActivityMapSelection s = new ActivityMapSelection(JActivityMap.this.m_selection);
                    int row = JActivityMap.this.pixToRow(e.getY());
                    double[] mouseRange = JActivityMap.this.pixToRange(e.getX());
                    if (JActivityMap.this.m_selectorResizeType == 11) {
                        s.setRange(new double[]{JActivityMap.this.m_selection.getRange()[0], mouseRange[1]});
                    } else if (JActivityMap.this.m_selectorResizeType == 10) {
                        s.setRange(new double[]{mouseRange[0], JActivityMap.this.m_selection.getRange()[1]});
                    } else {
                        s.setLead(row, mouseRange);
                    }
                    JActivityMap.this.setSelectionInternal(s);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JActivityMap.isButton1(e) && JActivityMap.this.m_pressedInsideMap) {
                    ActivityMapSelection s = new ActivityMapSelection(JActivityMap.this.m_selection);
                    int row = JActivityMap.this.pixToRow(e.getY());
                    JActivityMap.this.m_currentRowDrag = row;
                    double[] mouseRange = JActivityMap.this.pixToRange(e.getX());
                    if (JActivityMap.this.m_selectorResizeType == 11) {
                        s.setRange(new double[]{JActivityMap.this.m_selection.getRange()[0], mouseRange[1]});
                    } else if (JActivityMap.this.m_selectorResizeType == 10) {
                        s.setRange(new double[]{mouseRange[0], JActivityMap.this.m_selection.getRange()[1]});
                    } else {
                        s.setRange(new double[]{mouseRange[0], mouseRange[1]});
                        s.setLead(row, mouseRange);
                        int[] selectedRows = new int[]{JActivityMap.this.m_rowStartedDrag, JActivityMap.this.m_currentRowDrag};
                        s.setRows(selectedRows);
                    }
                    JActivityMap.this.setSelectionInternal(s);
                }
            }
        });
        this.m_activityProxyMouseListener = new MouseInputListener(){
            MouseClickedBugFix fix;

            @Override
            public void mouseEntered(MouseEvent e) {
                EventListener[] listeners;
                EventListener[] eventListenerArray = listeners = JActivityMap.this.m_listeners.getListeners(MouseListener.class);
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    EventListener listener = eventListenerArray[n2];
                    ((MouseListener)listener).mouseEntered(e);
                    ++n2;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                EventListener[] listeners;
                EventListener[] eventListenerArray = listeners = JActivityMap.this.m_listeners.getListeners(MouseListener.class);
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    EventListener listener = eventListenerArray[n2];
                    ((MouseListener)listener).mouseExited(e);
                    ++n2;
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                EventListener[] listeners;
                this.fix = new MouseClickedBugFix(e);
                EventListener[] eventListenerArray = listeners = JActivityMap.this.m_listeners.getListeners(MouseListener.class);
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    EventListener listener = eventListenerArray[n2];
                    ((MouseListener)listener).mousePressed(e);
                    ++n2;
                }
                if (JActivityMap.isButton1(e)) {
                    e = SwingUtilities.convertMouseEvent(e.getComponent(), e, JActivityMap.this);
                    JActivityMap.this.dispatchEvent(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                EventListener[] listeners;
                EventListener[] eventListenerArray = listeners = JActivityMap.this.m_listeners.getListeners(MouseListener.class);
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    EventListener listener = eventListenerArray[n2];
                    ((MouseListener)listener).mouseReleased(e);
                    ++n2;
                }
                if (JActivityMap.isButton1(e)) {
                    JActivityMap.this.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, JActivityMap.this));
                }
                if (this.fix != null) {
                    this.fix.mouseReleased(this, e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                EventListener[] listeners;
                if (this.fix.mouseClicked()) {
                    return;
                }
                EventListener[] eventListenerArray = listeners = JActivityMap.this.m_listeners.getListeners(MouseListener.class);
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    EventListener listener = eventListenerArray[n2];
                    ((MouseListener)listener).mouseClicked(e);
                    ++n2;
                }
                if (JActivityMap.isButton1(e) && e.getClickCount() == 1) {
                    e = SwingUtilities.convertMouseEvent(e.getComponent(), e, JActivityMap.this);
                    JActivityMap.this.dispatchEvent(e);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JActivityMap.isButton1(e)) {
                    JActivityMap.this.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, JActivityMap.this));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (JActivityMap.isButton1(e)) {
                    JActivityMap.this.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, JActivityMap.this));
                }
            }
        };
        this.m_activityProxyFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                EventListener[] listeners;
                EventListener[] eventListenerArray = listeners = JActivityMap.this.m_listeners.getListeners(FocusListener.class);
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    EventListener listener = eventListenerArray[n2];
                    ((FocusListener)listener).focusGained(e);
                    ++n2;
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                EventListener[] listeners;
                EventListener[] eventListenerArray = listeners = JActivityMap.this.m_listeners.getListeners(FocusListener.class);
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    EventListener listener = eventListenerArray[n2];
                    ((FocusListener)listener).focusLost(e);
                    ++n2;
                }
            }
        };
        this.setModel(new ActivityMapModel(){

            @Override
            public int getRowCount() {
                return 0;
            }

            @Override
            public int getRowHeight(int rowIndex) {
                return 0;
            }

            @Override
            public int getRowLocation(int rowIndex) {
                return 0;
            }

            @Override
            public int getRowAtLocation(int y) {
                return -1;
            }

            @Override
            public int getHeaderHeight() {
                return 0;
            }

            @Override
            public ActivityComponent[] getActivities() {
                return new ActivityComponent[0];
            }

            @Override
            public double[] getActivityRange(ActivityComponent a) {
                return null;
            }
        });
        this.setColumnModel(new ActivityMapColumnModel(){

            @Override
            public double[] getMajorColumnRange(Object majorColumn) {
                return new double[2];
            }

            @Override
            public String getMajorColumnText(Object column, int size) {
                return null;
            }

            @Override
            public Object[] getMajorColumns() {
                return new Object[0];
            }

            @Override
            public double[] getMinorColumnRange(Object mainorColumn) {
                return new double[2];
            }

            @Override
            public String getMinorColumnText(Object column, int size) {
                return null;
            }

            @Override
            public Object[] getMinorColumns(Object majorColumn) {
                return new Object[0];
            }

            @Override
            public double[] snapRange(double d) {
                return new double[]{0.0, 0.0};
            }

            @Override
            public String getMajorColumnTooltipText(Object column) {
                return null;
            }

            @Override
            public String getMinorColumnTooltipText(Object column) {
                return null;
            }
        });
    }

    public void addActivityMapSelectionListener(ActivityMapSelectionListener listener) {
        this.m_listeners.add(ActivityMapSelectionListener.class, listener);
    }

    public void removeActivityMapSelectionListener(ActivityMapSelectionListener listener) {
        this.m_listeners.remove(ActivityMapSelectionListener.class, listener);
    }

    public void addActivityProxyMouseListener(MouseListener listener) {
        this.m_listeners.add(MouseListener.class, listener);
    }

    public void removeActivityProxyMouseListener(MouseListener listener) {
        this.m_listeners.remove(MouseListener.class, listener);
    }

    public void addActivityProxyFocusListener(FocusListener listener) {
        this.m_listeners.add(FocusListener.class, listener);
    }

    public void removeActivityProxyFocusListener(FocusListener listener) {
        this.m_listeners.remove(FocusListener.class, listener);
    }

    private void fireSelectionChanged() {
        this.fireActivityMapSelectionEvent(new ActivityMapSelectionEvent(this, this.getSelectedRows(), this.getSelectedRange()));
    }

    private void fireActivityMapSelectionEvent(ActivityMapSelectionEvent e) {
        EventListener[] listeners;
        EventListener[] eventListenerArray = listeners = this.m_listeners.getListeners(ActivityMapSelectionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            EventListener listener = eventListenerArray[n2];
            ((ActivityMapSelectionListener)listener).selectionChanged(e);
            ++n2;
        }
    }

    public int getRowCount() {
        return this.m_model.getRowCount();
    }

    public double[] pixToRange(int x) {
        return this.getColumnModel().snapRange(1.0 * (double)x / (double)this.getVisibleViewportView().width);
    }

    public int pixToRow(int y) {
        int i = this.getModel().getRowAtLocation(y);
        if (i < 0) {
            i = 0;
        } else if (i >= this.getModel().getRowCount()) {
            i = this.getModel().getRowCount() - 1;
        }
        return i;
    }

    private Rectangle getVisibleViewportView() {
        if (this.m_viewport != null) {
            return this.m_viewport.getVisibleRect();
        }
        return this.getBounds();
    }

    public boolean isInsideSelection(MouseEvent e) {
        if (this.m_selection != null) {
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this);
            return this.m_selection.contains(this.pixToRow(p.y), this.pixToRange(p.x));
        }
        return false;
    }

    public ActivityMapModel getModel() {
        return this.m_model;
    }

    public void setModel(ActivityMapModel m) {
        if (m != null && m != this.m_model) {
            this.m_model = m;
            Object[] objectArray = this.getComponents();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = objectArray[n2];
                if (c instanceof ActivityComponent) {
                    c.removeMouseListener(this.m_activityProxyMouseListener);
                    c.removeMouseMotionListener(this.m_activityProxyMouseListener);
                    c.removeFocusListener(this.m_activityProxyFocusListener);
                }
                ++n2;
            }
            this.removeAll();
            this.add(this.m_selector);
            objectArray = this.m_model.getActivities();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object a = objectArray[n2];
                this.add((JComponent)a);
                ((JComponent)a).addMouseListener(this.m_activityProxyMouseListener);
                ((JComponent)a).addMouseMotionListener(this.m_activityProxyMouseListener);
                ((JComponent)a).addFocusListener(this.m_activityProxyFocusListener);
                ++n2;
            }
            this.revalidateAndRepaint();
        }
    }

    public ActivityMapColumnModel getColumnModel() {
        return this.m_columnModel;
    }

    public void setColumnModel(ActivityMapColumnModel m) {
        if (m != null && m != this.m_columnModel) {
            this.m_columnModel = m;
            this.revalidateAndRepaint();
        }
    }

    public JActivityMapHeader getActivityMapHeader() {
        return this.m_header;
    }

    public Rectangle getCellRect(int beginRowIndex, int endRowIndex, double[] normalizedColumnRange) {
        Rectangle r = this.getRect(normalizedColumnRange);
        if (beginRowIndex <= endRowIndex) {
            if (beginRowIndex >= 0) {
                r.y = this.getModel().getRowLocation(beginRowIndex);
            }
            if (endRowIndex >= 0) {
                r.height = this.getModel().getRowLocation(endRowIndex) + this.getModel().getRowHeight(endRowIndex) - r.y;
            }
        }
        return r;
    }

    public Rectangle getRect(double[] normalizedColumnRange) {
        Rectangle r = new Rectangle();
        if (normalizedColumnRange != null) {
            int b;
            int w = this.getVisibleViewportView().width;
            int a = (int)(normalizedColumnRange[0] * (double)w);
            if (a < 0) {
                a = -1;
            }
            if (a >= w) {
                a = w;
            }
            if ((b = (int)(normalizedColumnRange[1] * (double)w)) < 0) {
                b = -1;
            }
            if (b >= w) {
                b = w;
            }
            r.x = a;
            r.width = b - a;
        }
        return r;
    }

    public JSelector getSelector() {
        return this.m_selector;
    }

    public double[] getSelectedRange() {
        return this.m_selection.getRange();
    }

    private void setSelectionInternal(ActivityMapSelection s) {
        if (!s.equals(this.m_selection)) {
            this.m_selection = s;
            this.m_selector.revalidate();
            this.m_selector.repaint();
            this.fireSelectionChanged();
        }
    }

    public int[] getSelectedRows() {
        return this.m_selection.getRows();
    }

    public ActivityComponent getFocusedActivity() {
        Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (comp instanceof ActivityComponent && SwingUtilities.isDescendingFrom(comp, this)) {
            return (ActivityComponent)((Object)comp);
        }
        return null;
    }

    public void setSelection(int[] newRows, double[] newRange) {
        ActivityMapSelection s = new ActivityMapSelection(this.m_selection);
        s.setRows(newRows);
        s.setRange(newRange);
        this.setSelectionInternal(s);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    @Override
    public void removeNotify() {
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected void configureEnclosingScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            this.m_viewport = viewport;
            scrollPane.setColumnHeaderView(this.getActivityMapHeader());
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            this.m_viewport = null;
            scrollPane.setColumnHeaderView(null);
        }
    }

    protected void revalidateAndRepaint() {
        this.revalidate();
        this.m_header.revalidate();
        this.repaint();
        this.m_header.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintGrid(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    private void paintGrid(Graphics g) {
        int rowCount = this.getModel().getRowCount();
        if (rowCount > 0) {
            Object[] majorCols = this.getColumnModel().getMajorColumns();
            ArrayList<Object> minorColList = new ArrayList<Object>();
            Object[] objectArray = majorCols;
            int n = majorCols.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                minorColList.addAll(Arrays.asList(this.getColumnModel().getMinorColumns(o)));
                ++n2;
            }
            Object[] minorCols = minorColList.toArray();
            int[] rows = new int[rowCount];
            int[] heights = new int[rowCount];
            Rectangle[] majorRects = new Rectangle[majorCols.length];
            Rectangle[] minorRects = new Rectangle[minorCols.length];
            int i = 0;
            while (i < rows.length) {
                rows[i] = this.getModel().getRowLocation(i);
                heights[i] = this.getModel().getRowHeight(i);
                ++i;
            }
            int minY = rows[0];
            int maxY = rows[rows.length - 1] + heights[heights.length - 1];
            i = 0;
            while (i < minorRects.length) {
                minorRects[i] = this.getRect(this.getColumnModel().getMinorColumnRange(minorCols[i]));
                minorRects[i].y = minY;
                minorRects[i].height = maxY - minY;
                if (i > 0 && minorRects[i - 1].x + minorRects[i - 1].width + 1 >= minorRects[i].x) {
                    minorRects[i - 1].width = minorRects[i].x - minorRects[i - 1].x;
                }
                ++i;
            }
            i = 0;
            while (i < majorRects.length) {
                majorRects[i] = this.getRect(this.getColumnModel().getMajorColumnRange(majorCols[i]));
                majorRects[i].y = minY;
                majorRects[i].height = maxY - minY;
                ++i;
            }
            g.setColor(new Color(0xEEEEEE));
            Rectangle[] rectangleArray = majorRects;
            int n3 = majorRects.length;
            int n4 = 0;
            while (n4 < n3) {
                Rectangle rect = rectangleArray[n4];
                int r = 0;
                while (r < rows.length) {
                    g.drawLine(rect.x, rows[r], rect.x + rect.width, rows[r]);
                    ++r;
                }
                ++n4;
            }
            rectangleArray = minorRects;
            n3 = minorRects.length;
            n4 = 0;
            while (n4 < n3) {
                Rectangle rect = rectangleArray[n4];
                g.drawLine(rect.x, minY, rect.x, maxY);
                g.drawLine(rect.x + rect.width, minY, rect.x + rect.width, maxY);
                ++n4;
            }
            g.setColor(Color.lightGray);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            Graphics2D g2d = (Graphics2D)g;
            Stroke old = g2d.getStroke();
            try {
                g2d.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{1.0f, 3.0f}, 1.0f));
                int i2 = 0;
                while (i2 < majorRects.length) {
                    Rectangle r = majorRects[i2];
                    if (i2 > 0) {
                        g.drawLine(r.x, r.y, r.x, r.height);
                    }
                    if (i2 + 1 < majorRects.length) {
                        g.drawLine(r.x + r.width - 1, r.y, r.x + r.width - 1, r.height);
                    }
                    ++i2;
                }
            }
            finally {
                g2d.setStroke(old);
            }
        }
    }

    private static boolean isButton1(MouseEvent e) {
        if (e.getButton() == 1) {
            return true;
        }
        return (e.getModifiersEx() & 0x400) != 0;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(10240, 10240);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (direction == 0) {
            return 100;
        }
        if (this.getModel().getRowCount() > 0) {
            return this.getModel().getRowHeight(0);
        }
        return 24;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (direction == 0) {
            return visibleRect.width;
        }
        return visibleRect.height;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public static Component getParentAt(Component comp, Point p) {
        return JActivityMap.getDeepestComponentAt(comp.getParent(), comp.getX() + p.x, comp.getY() + p.y, comp);
    }

    public static Component getDeepestComponentAt(Component parent, int x, int y, Component toExclude) {
        if (!parent.contains(x, y)) {
            return null;
        }
        if (parent instanceof Container) {
            Component[] components = ((Container)parent).getComponents();
            int i = 0;
            while (i < components.length) {
                Component comp = components[i];
                if (comp != null && comp.isVisible() && comp != toExclude) {
                    Point loc = comp.getLocation();
                    if ((comp = comp instanceof Container ? JActivityMap.getDeepestComponentAt(comp, x - loc.x, y - loc.y, toExclude) : comp.getComponentAt(x - loc.x, y - loc.y)) != null && comp.isVisible()) {
                        return comp;
                    }
                }
                ++i;
            }
        }
        return parent;
    }

    public void setActivityMap(IActivityMap<?, ?> scoutObject) {
        this.m_scoutActivityMap = scoutObject;
    }

    public IActivityMap<?, ?> getActivityMap() {
        return this.m_scoutActivityMap;
    }
}

