/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.decoration;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.action.menu.ISwingContextMenuMarker;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.MenuArrowDownIcon;
import org.eclipse.scout.rt.ui.swing.ext.decoration.AbstractDecorationItem;

public class ContextMenuDecorationItem
extends AbstractDecorationItem
implements ISwingContextMenuMarker {
    private PropertyChangeListener m_scoutPropertyChangeListener;
    private Rectangle m_bounds;
    private IContextMenu m_scoutContextMenu;
    private IconGroup m_iconGroup = MenuArrowDownIcon.createMenuArrowDownIconGroup(new Insets(2, 1, 15, 1));

    public ContextMenuDecorationItem(IContextMenu scoutContextMenu, JComponent owner, ISwingEnvironment environment) {
        super(owner, environment, false);
        this.m_scoutContextMenu = scoutContextMenu;
        this.init();
        this.setMouseOverCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    protected void init() {
        super.init();
        if (this.getScoutContextMenu() != null && this.m_scoutPropertyChangeListener == null) {
            this.m_scoutPropertyChangeListener = new P_ScoutPropertyChangeListener();
            this.getScoutContextMenu().addPropertyChangeListener(this.m_scoutPropertyChangeListener);
        }
        this.updateContextMenuVisibility();
    }

    public void destroy() {
        if (this.m_scoutPropertyChangeListener != null) {
            this.getScoutContextMenu().removePropertyChangeListener(this.m_scoutPropertyChangeListener);
            this.m_scoutPropertyChangeListener = null;
        }
    }

    private void updateContextMenuVisibility() {
        this.setMarkerVisible(this.getScoutContextMenu().isVisible());
    }

    @Override
    protected Rectangle paintInternal(Component c, Graphics g, int x, int y) {
        if (!this.isVisible()) {
            return NULL_RECTANGLE;
        }
        Icon icon = this.getIconForState();
        icon.paintIcon(c, g, x, y);
        return new Rectangle(x, y, icon.getIconWidth(), icon.getIconHeight());
    }

    private int calcArrowWidth(int line) {
        return 5 - line * 2;
    }

    @Override
    public int getWidth() {
        if (this.isVisible()) {
            return this.getIconForState().getIconWidth();
        }
        return 0;
    }

    @Override
    public int getHeight() {
        if (this.isVisible()) {
            return this.getIconForState().getIconHeight();
        }
        return 0;
    }

    public IContextMenu getScoutContextMenu() {
        return this.m_scoutContextMenu;
    }

    @Override
    public void setMarkerVisible(boolean visible) {
        this.setVisible(visible);
        this.getOwner().repaint();
    }

    @Override
    public boolean isMarkerVisible() {
        return this.isVisible();
    }

    private Icon getIconForState() {
        IconGroup.IconState iconState;
        switch (this.getState()) {
            case Disabled: {
                iconState = IconGroup.IconState.DISABLED;
                break;
            }
            case Rollover: {
                iconState = IconGroup.IconState.ROLLOVER;
                break;
            }
            case Selected: {
                iconState = IconGroup.IconState.SELECTED;
                break;
            }
            default: {
                iconState = IconGroup.IconState.NORMAL;
            }
        }
        return this.m_iconGroup.getIcon(iconState);
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ContextMenuDecorationItem.this.updateContextMenuVisibility();
                    }
                };
                ContextMenuDecorationItem.this.getEnvironment().invokeSwingLater(t);
            }
        }
    }
}

