/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JInternalFrame;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.Cell;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.CellElement;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.CellSplit;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.ViewElement;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.ViewSplit;

class ViewModel {
    private Map<JInternalFrame, ViewElement> m_frameToViewMap = new HashMap<JInternalFrame, ViewElement>();
    private Dimension m_minSize;
    private boolean m_mousePressed;

    public void rebuild(Cell[][] cells, CellSplit[][] rowSplits, CellSplit[][] colSplits) {
        JInternalFrame lastFrame;
        int c;
        this.m_frameToViewMap = new HashMap<JInternalFrame, ViewElement>();
        HashMap<CellSplit, Set<CellSplit>> rowSplitMS = new HashMap<CellSplit, Set<CellSplit>>();
        HashMap<CellSplit, Set<CellSplit>> colSplitMS = new HashMap<CellSplit, Set<CellSplit>>();
        ComponentCell[][] cellMap = new ComponentCell[cells.length][cells[0].length];
        int r = 0;
        while (r < cellMap.length) {
            c = 0;
            while (c < cellMap[r].length) {
                cellMap[r][c] = new ComponentCell();
                ++c;
            }
            ++r;
        }
        this.mapCells(cells, cellMap);
        r = 0;
        while (r < cells.length) {
            c = 0;
            while (c < cells[r].length) {
                ViewElement v;
                JInternalFrame frame = (JInternalFrame)cellMap[r][c].component;
                if (frame != null && (v = this.m_frameToViewMap.get(frame)) == null) {
                    v = new ViewElement(frame);
                    this.m_frameToViewMap.put(frame, v);
                }
                ++c;
            }
            ++r;
        }
        ViewElement[][] viewMap = new ViewElement[cellMap.length][cellMap[0].length];
        for (ViewElement v : this.m_frameToViewMap.values()) {
            this.mapFrameToView(cellMap, viewMap, v, rowSplits, colSplits, rowSplitMS, colSplitMS);
        }
        for (ViewElement v : this.m_frameToViewMap.values()) {
            v.top = this.calculateCompleteViewSplit(rowSplitMS, v.top.getCellSplits(), viewMap);
            v.left = this.calculateCompleteViewSplit(colSplitMS, v.left.getCellSplits(), viewMap);
            v.bottom = this.calculateCompleteViewSplit(rowSplitMS, v.bottom.getCellSplits(), viewMap);
            v.right = this.calculateCompleteViewSplit(colSplitMS, v.right.getCellSplits(), viewMap);
        }
        int r2 = 0;
        while (r2 < rowSplits.length) {
            int c2 = 0;
            while (c2 < rowSplits[r2].length) {
                rowSplits[r2][c2].setUsedInModel(false);
                ++c2;
            }
            ++r2;
        }
        r2 = 0;
        while (r2 < colSplits.length) {
            int c3 = 0;
            while (c3 < colSplits[r2].length) {
                colSplits[r2][c3].setUsedInModel(false);
                ++c3;
            }
            ++r2;
        }
        for (ViewElement v : this.m_frameToViewMap.values()) {
            for (CellSplit c4 : v.top.getCellSplits()) {
                c4.setUsedInModel(true);
            }
            for (CellSplit c4 : v.left.getCellSplits()) {
                c4.setUsedInModel(true);
            }
            for (CellSplit c4 : v.bottom.getCellSplits()) {
                c4.setUsedInModel(true);
            }
            for (CellSplit c4 : v.right.getCellSplits()) {
                c4.setUsedInModel(true);
            }
        }
        int c5 = 0;
        while (c5 < rowSplits[0].length) {
            int r3 = 1;
            while (r3 < rowSplits.length - 1) {
                CellSplit a = rowSplits[r3][c5];
                CellSplit b = rowSplits[r3 + 1][c5];
                if (a.getLocation() + 20 > b.getLocation() && a.isUsedInModel() && b.isUsedInModel()) {
                    int tmp = a.getLocation();
                    a.setLocation(b.getLocation());
                    b.setLocation(tmp);
                }
                ++r3;
            }
            ++c5;
        }
        for (ViewElement v : this.m_frameToViewMap.values()) {
            v.validateMinMaxSizes();
        }
        for (ViewElement v : this.m_frameToViewMap.values()) {
            JInternalFrame frame = v.getFrame();
            frame.putClientProperty("swingScout.resizeNEnabled", v.top.isFixed() ? Boolean.FALSE : Boolean.TRUE);
            frame.putClientProperty("swingScout.resizeWEnabled", v.left.isFixed() ? Boolean.FALSE : Boolean.TRUE);
            frame.putClientProperty("swingScout.resizeSEnabled", v.bottom.isFixed() ? Boolean.FALSE : Boolean.TRUE);
            frame.putClientProperty("swingScout.resizeEEnabled", v.right.isFixed() ? Boolean.FALSE : Boolean.TRUE);
        }
        HashMap<JInternalFrame, Dimension> minSizeCache = new HashMap<JInternalFrame, Dimension>();
        int maxOfMinWidth = 0;
        int r4 = 0;
        while (r4 < cellMap.length) {
            int minWidth = 0;
            lastFrame = null;
            int c6 = 0;
            while (c6 < cellMap[r4].length) {
                JInternalFrame f;
                if (viewMap[r4][c6] != null && (f = viewMap[r4][c6].getFrame()) != lastFrame) {
                    lastFrame = f;
                    Dimension d = (Dimension)minSizeCache.get(f);
                    if (d == null) {
                        d = f.getMinimumSize();
                        minSizeCache.put(f, d);
                    }
                    minWidth += d.width;
                }
                ++c6;
            }
            maxOfMinWidth = Math.max(maxOfMinWidth, minWidth);
            ++r4;
        }
        int maxOfMinHeight = 0;
        int c7 = 0;
        while (c7 < cellMap[0].length) {
            int minHeight = 0;
            lastFrame = null;
            int r5 = 0;
            while (r5 < cellMap.length) {
                JInternalFrame f;
                if (viewMap[r5][c7] != null && (f = viewMap[r5][c7].getFrame()) != lastFrame) {
                    lastFrame = f;
                    Dimension d = (Dimension)minSizeCache.get(f);
                    if (d == null) {
                        d = f.getMinimumSize();
                        minSizeCache.put(f, d);
                    }
                    minHeight += d.height;
                }
                ++r5;
            }
            maxOfMinHeight = Math.max(maxOfMinHeight, minHeight);
            ++c7;
        }
        this.m_minSize = new Dimension(maxOfMinWidth, maxOfMinHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.m_minSize);
    }

    public boolean isMousePressed() {
        return this.m_mousePressed;
    }

    public void setMousePressed(boolean mousePressed) {
        this.m_mousePressed = mousePressed;
    }

    private void mapCells(Cell[][] cells, ComponentCell[][] map) {
        int r = 0;
        while (r < cells.length) {
            int c = 0;
            while (c < cells[r].length) {
                this.mapCell(cells[r][c], map);
                ++c;
            }
            ++r;
        }
    }

    private void mapCell(Cell cell, ComponentCell[][] maps) {
        if (cell.getCellElementCount() > 0) {
            CellElement ce = cell.getCellElement(cell.getCellElementCount() - 1);
            int r = 0;
            while (r < maps.length) {
                int c = 0;
                while (c < maps[r].length) {
                    this.mapComponent(ce.getComponent(), ce.getDistributionMatrix()[r][c], maps[r][c]);
                    ++c;
                }
                ++r;
            }
        }
    }

    private void mapComponent(Component aComp, float aPrio, ComponentCell cc) {
        if (aComp.isVisible() && aPrio > cc.prio) {
            cc.prio = aPrio;
            cc.component = aComp;
        }
    }

    private void mapFrameToView(ComponentCell[][] cellMap, ViewElement[][] viewMap, ViewElement v, CellSplit[][] rowSplits, CellSplit[][] colSplits, Map<CellSplit, Set<CellSplit>> rowSplitMS, Map<CellSplit, Set<CellSplit>> colSplitMS) {
        int c;
        JInternalFrame frame = v.getFrame();
        int largestSize = 0;
        int minR = 0;
        int maxR = 0;
        int minC = 0;
        int maxC = 0;
        int r = 0;
        while (r < cellMap.length) {
            c = 0;
            while (c < cellMap[r].length) {
                if (cellMap[r][c].component == frame) {
                    int h = 1;
                    while (r + h < cellMap.length && cellMap[r + h][c].component == frame) {
                        ++h;
                    }
                    int tr = r;
                    while (tr < r + h) {
                        int w = 1;
                        while (c + w < cellMap[tr].length && cellMap[tr][c + w].component == frame) {
                            ++w;
                        }
                        if (w * h > largestSize) {
                            minR = r;
                            maxR = r + h - 1;
                            minC = c;
                            maxC = c + w - 1;
                            largestSize = w * h;
                        }
                        ++tr;
                    }
                }
                ++c;
            }
            ++r;
        }
        if (largestSize > 0) {
            r = minR;
            while (r <= maxR) {
                c = minC;
                while (c <= maxC) {
                    viewMap[r][c] = v;
                    ++c;
                }
                ++r;
            }
            HashSet<CellSplit> tieList = new HashSet<CellSplit>();
            tieList.clear();
            int r2 = 0;
            while (r2 <= colSplits.length - 1) {
                tieList.add(colSplits[r2][minC]);
                ++r2;
            }
            v.left = this.tieCellSplits(colSplitMS, tieList, viewMap);
            tieList.clear();
            r2 = 0;
            while (r2 <= colSplits.length - 1) {
                tieList.add(colSplits[r2][maxC + 1]);
                ++r2;
            }
            v.right = this.tieCellSplits(colSplitMS, tieList, viewMap);
            tieList.clear();
            c = minC;
            while (c <= maxC) {
                tieList.add(rowSplits[minR][c]);
                ++c;
            }
            v.top = this.tieCellSplits(rowSplitMS, tieList, viewMap);
            tieList.clear();
            c = minC;
            while (c <= maxC) {
                tieList.add(rowSplits[maxR + 1][c]);
                ++c;
            }
            v.bottom = this.tieCellSplits(rowSplitMS, tieList, viewMap);
        }
    }

    private ViewSplit tieCellSplits(Map<CellSplit, Set<CellSplit>> splitMS, Set<CellSplit> list, ViewElement[][] viewMap) {
        HashSet<CellSplit> splitSet = new HashSet<CellSplit>();
        splitSet.addAll(list);
        for (CellSplit cs : list) {
            Set<CellSplit> subSet = splitMS.get(cs);
            if (subSet == null) continue;
            splitSet.addAll(subSet);
        }
        for (CellSplit cs : splitSet) {
            splitMS.put(cs, splitSet);
        }
        ViewSplit vs = new ViewSplit(splitSet);
        return vs;
    }

    private ViewSplit calculateCompleteViewSplit(Map<CellSplit, Set<CellSplit>> splitMS, Set<CellSplit> splitSet, ViewElement[][] viewMap) {
        HashSet<CellSplit> completeSet = new HashSet<CellSplit>();
        for (CellSplit split : splitSet) {
            Set<CellSplit> subSet = splitMS.get(split);
            if (subSet == null) continue;
            completeSet.addAll(subSet);
        }
        HashSet<ViewElement> leftViews = new HashSet<ViewElement>();
        HashSet<ViewElement> rightViews = new HashSet<ViewElement>();
        for (CellSplit split : completeSet) {
            ViewElement v;
            Cell cell = split.getLeftItem();
            if (cell != null && (v = viewMap[cell.getRow()][cell.getColumn()]) != null) {
                leftViews.add(v);
            }
            if ((cell = split.getRightItem()) == null || (v = viewMap[cell.getRow()][cell.getColumn()]) == null) continue;
            rightViews.add(v);
        }
        ViewSplit vs = new ViewSplit(completeSet, leftViews, rightViews);
        return vs;
    }

    public Rectangle getBoundsFor(JInternalFrame frame) {
        ViewElement v = this.m_frameToViewMap.get(frame);
        if (v != null && v.left != null && v.right != null && v.top != null && v.bottom != null) {
            return new Rectangle(v.left.getLocation(), v.top.getLocation(), v.right.getLocation() - v.left.getLocation(), v.bottom.getLocation() - v.top.getLocation());
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public void iconify(JInternalFrame f, Rectangle newR) {
        ViewElement view = this.m_frameToViewMap.get(f);
        if (view != null) {
            view.resize(newR);
        }
    }

    public void resize(JInternalFrame f, Rectangle newR) {
        ViewElement view;
        if (this.isMousePressed() && (view = this.m_frameToViewMap.get(f)) != null) {
            view.resize(newR);
        }
    }

    public void fitSize(JInternalFrame f, Dimension size) {
        ViewElement view = this.m_frameToViewMap.get(f);
        if (view != null) {
            view.fitSize(size);
        }
    }

    static class ComponentCell {
        float prio;
        Component component;

        ComponentCell() {
        }
    }
}

