/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.layout;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swt.basic.calendar.layout.MonthCellData;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SwtCalendar;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MonthCellLayout
extends Layout {
    protected static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtCalendar.class);
    private int numColumns = 1;
    private int numLines = 1;

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public void setNumLines(int numLines) {
        this.numLines = numLines;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(0, 0);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        Rectangle clipRect = composite.getClientArea();
        float cellWidth = (float)clipRect.width / (float)this.numColumns;
        float cellHeight = (float)clipRect.height / (float)this.numLines;
        int[][] ary = new int[this.numColumns][this.numLines];
        int v = 0;
        while (v < this.numLines) {
            int h = 0;
            while (h < this.numColumns) {
                ary[h][v] = -1;
                ++h;
            }
            ++v;
        }
        int colIndex = 0;
        int lineIndex = 0;
        int i = 0;
        while (i < children.length) {
            if (ary[colIndex][lineIndex] == -1) {
                Control child = children[i];
                MonthCellData dat = (MonthCellData)child.getLayoutData();
                int hSpan = Math.max(1, Math.min(dat.getHorizontalSpan(), this.numColumns - colIndex));
                int vSpan = Math.max(1, Math.min(dat.getVerticalSpan(), this.numLines - lineIndex));
                int v2 = 0;
                while (v2 < vSpan) {
                    int h = 0;
                    while (h < hSpan) {
                        ary[colIndex + h][lineIndex + v2] = i;
                        ++h;
                    }
                    ++v2;
                }
                ++i;
            }
            if ((colIndex = (colIndex + 1) % this.numColumns) % this.numColumns != 0) continue;
            ++lineIndex;
        }
        int lastId = -1;
        int v3 = 0;
        while (v3 < this.numLines) {
            int h = 0;
            while (h < this.numColumns) {
                int index = ary[h][v3];
                if (index > lastId) {
                    Control child = children[index];
                    MonthCellData dat = (MonthCellData)child.getLayoutData();
                    int x = Math.round((float)h * cellWidth);
                    int y = Math.round((float)v3 * cellHeight);
                    int width = Math.round((float)dat.getHorizontalSpan() * cellWidth);
                    int height = Math.round((float)dat.getVerticalSpan() * cellHeight);
                    Rectangle bounds = new Rectangle(x, y, width, height);
                    child.setBounds(bounds);
                    lastId = index;
                }
                ++h;
            }
            ++v3;
        }
    }
}

