/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public abstract class AbstractKeyboardNavigationSupport {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractKeyboardNavigationSupport.class);
    private final long m_delay;
    private long m_timeoutTimestamp;
    private String m_filterText = "";
    private Object navigationLock = new Object();
    private P_NavigationJob m_navigationJob;

    public AbstractKeyboardNavigationSupport() {
        this(1000L);
    }

    public AbstractKeyboardNavigationSupport(long delay) {
        this.m_delay = delay;
        this.m_navigationJob = new P_NavigationJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChar(char c) {
        Object object = this.navigationLock;
        synchronized (object) {
            if (Character.isLetter(c)) {
                if (System.currentTimeMillis() > this.m_timeoutTimestamp) {
                    this.m_filterText = "";
                }
                String newText = "" + Character.toLowerCase(c);
                this.m_filterText = String.valueOf(this.m_filterText) + newText;
                if (this.m_navigationJob != null) {
                    this.m_navigationJob.cancel();
                } else {
                    this.m_navigationJob = new P_NavigationJob();
                }
                this.m_navigationJob.schedule(300L);
                this.m_timeoutTimestamp = System.currentTimeMillis() + this.m_delay;
            }
        }
    }

    abstract void handleSearchPattern(String var1);

    private class P_NavigationJob
    extends Job {
        public P_NavigationJob() {
            super("");
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            String pattern;
            Object object = AbstractKeyboardNavigationSupport.this.navigationLock;
            synchronized (object) {
                if (monitor.isCanceled() || StringUtility.isNullOrEmpty((CharSequence)AbstractKeyboardNavigationSupport.this.m_filterText)) {
                    return Status.CANCEL_STATUS;
                }
                pattern = StringUtility.toRegExPattern((String)AbstractKeyboardNavigationSupport.this.m_filterText.toLowerCase());
                pattern = String.valueOf(pattern) + ".*";
            }
            AbstractKeyboardNavigationSupport.this.handleSearchPattern(pattern);
            return Status.OK_STATUS;
        }
    }
}

