/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table.celleditor;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableUtility;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.basic.ISwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.IFormFieldPopupListener;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.SwtScoutFormFieldPopup;
import org.eclipse.scout.rt.ui.swt.keystroke.SwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableCellEditor
extends CellEditor {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableCellEditor.class);
    private ISwtEnvironment m_environment;
    private P_FocusLostListener m_focusLostListener;
    private Composite m_container;
    private Image m_image;
    private IColumn<?> m_scoutColumn;
    private ITableRow m_scoutRow;
    private ITable m_scoutTable;
    private TableColumn m_swtColumn;
    private Table m_swtTable;
    private TableViewer m_tableViewer;
    private boolean m_requestFocus;

    public TableCellEditor(TableViewer tableViewer, TableColumn swtColumn, ITableRow scoutRow, ISwtEnvironment environment) {
        super((Composite)tableViewer.getTable());
        this.m_scoutRow = scoutRow;
        this.m_scoutColumn = (IColumn)swtColumn.getData("scoutColumn");
        this.m_scoutTable = this.m_scoutColumn.getTable();
        this.m_swtColumn = swtColumn;
        this.m_tableViewer = tableViewer;
        this.m_swtTable = tableViewer.getTable();
        this.m_environment = environment;
        this.m_focusLostListener = new P_FocusLostListener();
    }

    protected Control createControl(Composite parent) {
        this.m_container = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(wHint, hHint);
            }
        };
        this.m_container.setLayout((Layout)new FillLayout());
        return this.m_container;
    }

    protected Object doGetValue() {
        return null;
    }

    protected void doSetValue(Object value) {
    }

    public void activate(ColumnViewerEditorActivationEvent e) {
        IFormField formField;
        this.m_requestFocus = true;
        this.m_focusLostListener.install();
        this.m_environment.addKeyStroke((Widget)this.m_container, new SwtKeyStroke(27){

            @Override
            public void handleSwtAction(Event event) {
                event.doit = false;
                TableCellEditor.this.fireCancelEditor();
            }
        });
        this.m_environment.addKeyStroke((Widget)this.m_container, new SwtKeyStroke(13){

            @Override
            public void handleSwtAction(Event event) {
                event.doit = false;
                TableCellEditor.this.fireApplyEditorValue();
            }
        });
        this.m_environment.addKeyStroke((Widget)this.m_container, new SwtKeyStroke(0x1000050){

            @Override
            public void handleSwtAction(Event event) {
                event.doit = false;
                TableCellEditor.this.fireApplyEditorValue();
            }
        });
        if (this.m_scoutColumn instanceof IBooleanColumn) {
            if (e.sourceEvent instanceof MouseEvent) {
                this.m_requestFocus = false;
                return;
            }
            ViewerCell cell = (ViewerCell)e.getSource();
            this.m_image = cell.getImage();
            cell.setImage(null);
        }
        if ((formField = this.createFormField()) == null) {
            LOG.warn("Failed to create FormField for cell-editor; editing mode canceled.");
            this.m_requestFocus = false;
            this.fireCancelEditor();
            return;
        }
        ISwtScoutComposite<Object> swtScoutFormField = formField instanceof IStringField && ((IStringField)formField).isMultilineText() ? this.createPopupEditorControl(this.m_container, formField) : this.m_environment.createFormField(this.m_container, formField);
        this.decorateEditorComposite(swtScoutFormField, this.m_scoutRow, this.m_scoutColumn);
        this.m_container.layout(true, true);
        this.m_container.setVisible(true);
    }

    protected void doSetFocus() {
        if (!this.m_requestFocus) {
            return;
        }
        this.m_container.traverse(16);
        Control focusControl = this.m_container.getDisplay().getFocusControl();
        if (focusControl != null && SwtUtility.isAncestorOf((Control)this.m_container, focusControl)) {
            focusControl.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    switch (e.detail) {
                        case 2: 
                        case 4: {
                            e.doit = false;
                            break;
                        }
                        case 16: {
                            e.doit = false;
                            TableCellEditor.this.fireApplyEditorValue();
                            TableCellEditor.this.enqueueEditNextTableCell(true);
                            break;
                        }
                        case 8: {
                            e.doit = false;
                            TableCellEditor.this.fireApplyEditorValue();
                            TableCellEditor.this.enqueueEditNextTableCell(false);
                        }
                    }
                }
            });
        }
    }

    protected void deactivate(ColumnViewerEditorDeactivationEvent e) {
        ViewerCell cell = (ViewerCell)e.getSource();
        if (this.m_image != null) {
            cell.setImage(this.m_image);
        }
        this.m_image = null;
        Control[] controlArray = this.m_container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        super.deactivate(e);
        this.m_focusLostListener.uninstall();
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    protected void enqueueEditNextTableCell(final boolean forward) {
        this.m_environment.invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                ITable table = TableCellEditor.this.m_scoutColumn.getTable();
                TableUtility.editNextTableCell((ITable)table, (ITableRow)TableCellEditor.this.m_scoutRow, (IColumn)TableCellEditor.this.m_scoutColumn, (boolean)forward, (TableUtility.ITableCellEditorFilter)new TableUtility.ITableCellEditorFilter(){

                    public boolean accept(ITableRow rowx, IColumn<?> colx) {
                        return true;
                    }
                });
            }
        }, 0L);
    }

    protected ISwtScoutComposite<? extends IFormField> createPopupEditorControl(Composite parent, IFormField formField) {
        GridData gd = formField.getGridData();
        gd.h = 1;
        gd.w = 0;
        gd.weightY = 1.0;
        gd.weightX = 1.0;
        formField.setGridDataInternal(gd);
        int prefWidth = gd.widthInPixel;
        int minWidth = this.m_swtColumn.getWidth();
        int prefHeight = gd.heightInPixel;
        int minHeight = Math.max(105, this.m_swtTable.getItemHeight());
        prefHeight = Math.max(prefHeight, minHeight);
        prefWidth = Math.max(prefWidth, minWidth);
        Composite cellEditorComposite = new Composite(parent, 0);
        final SwtScoutFormFieldPopup popup = new SwtScoutFormFieldPopup(cellEditorComposite);
        popup.setPrefHeight(prefHeight);
        popup.setPrefWidth(prefWidth);
        popup.setMinHeight(minHeight);
        popup.setMinWidth(minWidth);
        this.m_requestFocus = false;
        final IFormFieldPopupListener formFieldPopupListener = new IFormFieldPopupListener(){

            @Override
            public void handleEvent(int event) {
                if ((event & 1) > 0) {
                    SwtUtility.runSwtInputVerifier(popup.getSwtField());
                    TableCellEditor.this.fireApplyEditorValue();
                } else if ((event & 2) > 0) {
                    TableCellEditor.this.fireCancelEditor();
                }
                if ((event & 8) > 0) {
                    TableCellEditor.this.enqueueEditNextTableCell(false);
                } else if ((event & 4) > 0) {
                    TableCellEditor.this.enqueueEditNextTableCell(true);
                }
            }
        };
        popup.addListener(formFieldPopupListener);
        cellEditorComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                popup.removeListener(formFieldPopupListener);
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        popup.closePopup();
                    }
                });
            }
        });
        popup.createField(parent, formField, this.m_environment);
        return popup;
    }

    protected IFormField createFormField() {
        final Holder result = new Holder();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                result.setValue((Object)TableCellEditor.this.m_scoutTable.getUIFacade().prepareCellEditFromUI(TableCellEditor.this.m_scoutRow, TableCellEditor.this.m_scoutColumn));
            }
        };
        try {
            this.m_environment.invokeScoutLater(t, 2345L).join(2345L);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for the Form-Field to be created.", (Throwable)e);
        }
        return (IFormField)result.getValue();
    }

    protected void decorateEditorComposite(ISwtScoutComposite editorComposite, ITableRow scoutRow, IColumn<?> scoutCol) {
    }

    private class P_FocusLostListener
    implements Listener {
        private P_FocusLostListener() {
        }

        public void install() {
            TableCellEditor.this.m_environment.getDisplay().addFilter(15, (Listener)this);
        }

        public void uninstall() {
            TableCellEditor.this.m_environment.getDisplay().removeFilter(15, (Listener)this);
        }

        public void handleEvent(Event event) {
            Widget w = event.widget;
            if (w == null || !(w instanceof Control) || w.isDisposed()) {
                return;
            }
            TableViewer viewer = TableCellEditor.this.m_tableViewer;
            if (!viewer.isCellEditorActive()) {
                return;
            }
            Control focusOwner = (Control)w;
            Table table = TableCellEditor.this.m_tableViewer.getTable();
            if (SwtUtility.isAncestorOf((Control)table, focusOwner)) {
                return;
            }
            if (focusOwner.getShell() != table.getShell()) {
                Composite parentFocusOwner = focusOwner.getShell().getParent();
                while (parentFocusOwner != null) {
                    if (parentFocusOwner.getShell() == table.getShell()) {
                        return;
                    }
                    parentFocusOwner = parentFocusOwner.getShell().getParent();
                }
            }
            TableCellEditor.this.fireApplyEditorValue();
        }
    }
}

