/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields;

import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;

public class SwtScoutFormFieldGridData
extends LogicalGridData {
    private IFormField m_scoutField;

    public SwtScoutFormFieldGridData(IFormField scoutField) {
        this.m_scoutField = scoutField;
    }

    @Override
    public void validate() {
        GridData data = this.m_scoutField.getGridData();
        SwtScoutFormFieldGridData gc = this;
        gc.gridx = data.x;
        gc.gridy = data.y;
        gc.gridw = data.w;
        gc.gridh = data.h;
        gc.weightx = data.weightX;
        gc.weighty = data.weightY;
        if (gc.weightx < 0.0) {
            gc.weightx = Math.max(1.0, (double)gc.gridw);
        }
        if (gc.weighty < 0.0) {
            gc.weighty = this.inheritWeightY(this.m_scoutField);
        }
        gc.useUiWidth = data.useUiWidth;
        gc.useUiHeight = this.m_scoutField.getLabelPosition() == 4 ? true : data.useUiHeight;
        gc.horizontalAlignment = data.horizontalAlignment;
        gc.verticalAlignment = data.verticalAlignment;
        gc.fillHorizontal = data.fillHorizontal;
        gc.fillVertical = data.fillVertical;
        gc.widthHint = data.widthInPixel;
        gc.heightHint = data.heightInPixel;
        if (gc.weighty == 0.0 || gc.weighty < 0.0 && gc.gridh <= 1) {
            gc.fillVertical = false;
        }
    }

    private Double inheritWeightY(IFormField f) {
        Double d = this.inheritWeightYRec(f);
        if (d == null) {
            GridData data = f.getGridData();
            d = data.weightY >= 0.0 ? Double.valueOf(data.weightY) : Double.valueOf(data.h >= 2 ? data.h : 0);
        }
        return d;
    }

    private Double inheritWeightYRec(IFormField f) {
        boolean found = false;
        double sumWy = 0.0;
        if (f instanceof ICompositeField) {
            for (IFormField child : ((ICompositeField)f).getFields()) {
                if (!child.isVisible()) continue;
                GridData data = child.getGridData();
                if (data.weightY < 0.0) {
                    Double inheritWeightY = this.inheritWeightYRec(child);
                    if (inheritWeightY == null) continue;
                    found = true;
                    sumWy += inheritWeightY.doubleValue();
                    continue;
                }
                found = true;
                sumWy += data.weightY;
            }
        } else {
            sumWy = f.getGridData().h >= 2 ? f.getGridData().h : 0;
            found = true;
        }
        if (found) {
            return sumWy;
        }
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.m_scoutField.getLabel()) + ": " + super.toString();
    }
}

