/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.snapbox.button;

import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.swt.ext.SnapButtonMaximized;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.snapbox.button.ISwtScoutSnapBoxMaximizedButton;
import org.eclipse.scout.rt.ui.swt.util.SwtLayoutUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SwtScoutSnapBoxMaximizedButton
extends SwtScoutFieldComposite<IButton>
implements ISwtScoutSnapBoxMaximizedButton {
    private OptimisticLock m_selectionLock = new OptimisticLock();

    @Override
    protected void initializeSwt(Composite parent) {
        SnapButtonMaximized button = this.getEnvironment().getFormToolkit().createSnapButtonMaximized(parent);
        this.setSwtField((Control)button);
        button.addSelectionListener((SelectionListener)new P_SelectionListener());
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setIconIdFromScout(((IButton)this.getScoutObject()).getIconId());
        this.setSelectionFromScout(((IButton)this.getScoutObject()).isSelected());
    }

    public SnapButtonMaximized getSwtField() {
        return (SnapButtonMaximized)super.getSwtField();
    }

    protected void setSelectionFromScout(boolean booleanValue) {
        this.getSwtField().setSelected(booleanValue);
    }

    private void setIconIdFromScout(String iconId) {
        this.getSwtField().setImage(this.getEnvironment().getIcon(iconId));
    }

    @Override
    protected void setLabelFromScout(String s) {
        if (s == null) {
            s = "";
        }
        this.getSwtField().setText(s);
    }

    @Override
    protected void setFontFromScout(FontSpec scoutFont) {
        this.getSwtField().setFont(this.getEnvironment().getFont(scoutFont, this.getSwtField().getFont()));
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        this.getSwtField().setEnabled(b);
    }

    @Override
    protected void setVisibleFromScout(boolean b) {
        if (this.getSwtField().getVisible() != b) {
            this.getSwtField().setVisible(b);
            SwtLayoutUtility.invalidateLayout((Control)this.getSwtContainer());
        }
    }

    @Override
    protected void setTooltipTextFromScout(String s) {
        this.getSwtField().setToolTipText(s);
    }

    protected void handleSelectionFromSwt() {
        final boolean selection = !this.getSwtField().isSelected();
        Runnable job = new Runnable(){

            @Override
            public void run() {
                ((IButton)SwtScoutSnapBoxMaximizedButton.this.getScoutObject()).getUIFacade().setSelectedFromUI(selection);
            }
        };
        this.getEnvironment().invokeScoutLater(job, 0L);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if ("selected".equals(name)) {
            this.setSelectionFromScout((Boolean)newValue);
        } else if ("iconId".equals(name)) {
            this.setIconIdFromScout((String)newValue);
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    private class P_SelectionListener
    extends SelectionAdapter {
        private P_SelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SwtScoutSnapBoxMaximizedButton.this.handleSelectionFromSwt();
        }
    }
}

