/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.filechooser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SwtScoutFileChooser {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutFileChooser.class);
    private final IFileChooser m_scoutFileChooser;
    private final ISwtEnvironment m_environment;
    private final Shell m_parentShell;

    public SwtScoutFileChooser(Shell parentShell, IFileChooser fileChooser, ISwtEnvironment environment) {
        this.m_parentShell = parentShell;
        this.m_scoutFileChooser = fileChooser;
        this.m_environment = environment;
    }

    public void showFileChooser() {
        List<File> files = null;
        try {
            files = this.getScoutFileChooser().isFolderMode() ? this.showDirecoryDialog() : this.showFileDialog();
        }
        catch (Throwable throwable) {
            List<File> finalFiles = files;
            Runnable job = new Runnable(finalFiles){
                private final /* synthetic */ List val$finalFiles;
                {
                    this.val$finalFiles = list;
                }

                @Override
                public void run() {
                    SwtScoutFileChooser.this.m_scoutFileChooser.setFiles(this.val$finalFiles);
                }
            };
            this.getEnvironment().invokeScoutLater(job, 0L);
            throw throwable;
        }
        List<File> finalFiles = files;
        Runnable job = new /* invalid duplicate definition of identical inner class */;
        this.getEnvironment().invokeScoutLater(job, 0L);
    }

    protected List<File> showFileDialog() {
        int style = 0;
        style = this.getScoutFileChooser().isTypeLoad() ? (style |= 0x1000) : (style |= 0x2000);
        if (this.getScoutFileChooser().isMultiSelect()) {
            style |= 2;
        }
        String[] extensions = new String[]{"*.*"};
        if (this.getScoutFileChooser().getFileExtensions() != null) {
            ArrayList<String> extensionList = new ArrayList<String>();
            for (String ext : this.getScoutFileChooser().getFileExtensions()) {
                extensionList.add("*." + ext);
            }
            String allExtensions = StringUtility.join((String)";", extensionList);
            extensionList.add(0, allExtensions);
            extensions = extensionList.toArray(new String[extensionList.size()]);
        }
        FileDialog dialog = new FileDialog(this.getParentShell(), style);
        dialog.setFilterExtensions(extensions);
        if (this.getScoutFileChooser().getDirectory() != null) {
            dialog.setFilterPath(this.getScoutFileChooser().getDirectory().getAbsolutePath());
        }
        if (this.getScoutFileChooser().getFileName() != null) {
            dialog.setFileName(this.getScoutFileChooser().getFileName());
        }
        dialog.open();
        String filterPath = dialog.getFilterPath();
        String[] fileNames = dialog.getFileNames();
        ArrayList<File> result = new ArrayList<File>();
        if (filterPath.endsWith(":")) {
            filterPath = String.valueOf(filterPath) + "/";
        }
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            result.add(new Path(filterPath).append(fileName).toFile());
            ++n2;
        }
        return result;
    }

    protected List<File> showDirecoryDialog() {
        String selectedDirecotry;
        if (this.getScoutFileChooser().isMultiSelect()) {
            LOG.warn("Swt file chooser is not allowed in folder mode with multi select!");
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getParentShell());
        if (this.getScoutFileChooser().getDirectory() != null) {
            dialog.setFilterPath(this.getScoutFileChooser().getDirectory().getAbsolutePath());
        }
        if (StringUtility.hasText((CharSequence)(selectedDirecotry = dialog.open()))) {
            return CollectionUtility.arrayList((Object)new File(selectedDirecotry));
        }
        return CollectionUtility.emptyArrayList();
    }

    public IFileChooser getScoutFileChooser() {
        return this.m_scoutFileChooser;
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    public Shell getParentShell() {
        return this.m_parentShell;
    }
}

