/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.dto.formdata.FormDataAnnotation;
import org.eclipse.scout.sdk.workspace.dto.formdata.FormDataDtoUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class FormDataUpdateExecutor
extends AbstractExecutor {
    private IType m_formDataOwner;

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        try {
            FormDataAnnotation formDataAnnotation = ScoutTypeUtility.findFormDataAnnotation((IType)this.m_formDataOwner, (ITypeHierarchy)TypeUtility.getSupertypeHierarchy((IType)this.m_formDataOwner));
            if (FormDataAnnotation.isCreate((FormDataAnnotation)formDataAnnotation) && TypeUtility.exists((IJavaElement)formDataAnnotation.getFormDataType())) {
                new OperationJob(new IOperation[]{new FormDataDtoUpdateOperation(this.m_formDataOwner, formDataAnnotation)}).schedule();
            } else {
                MessageBox box = new MessageBox(shell, 34);
                box.setMessage(Texts.get((String)"CheckFormDataAnnot"));
                box.open();
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("unable to calculate form data type for update of element '" + this.m_formDataOwner + "'.", e);
        }
        return null;
    }

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_formDataOwner = UiUtility.getTypeFromSelection(selection);
        return this.isEditable((IJavaElement)this.m_formDataOwner) && this.m_formDataOwner.getDeclaringType() == null;
    }
}

