/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.library.LibraryBundlesAddOperation;
import org.eclipse.scout.sdk.ui.action.library.LibraryBundleLinkAction;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LibraryBundleLinkExecutor
extends AbstractExecutor {
    private IScoutBundle m_bundle;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_bundle = UiUtility.getScoutBundleFromSelection(selection);
        return this.isEditable(this.m_bundle);
    }

    @Override
    public Object run(final Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                PluginSelectionDialog dialog = new PluginSelectionDialog(shell, LibraryBundleLinkExecutor.this.getPotentialLibraryBundles(LibraryBundleLinkExecutor.this.m_bundle), true);
                dialog.setDialogBoundsSettings(ScoutSdkUi.getDefault().getDialogSettingsSection(String.valueOf(LibraryBundleLinkAction.class.getName()) + ".DialogSettings"), 2);
                dialog.setInitialPattern("**");
                dialog.create();
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    HashSet<IPluginModelBase> libraries = new HashSet<IPluginModelBase>(result.length);
                    Object[] objectArray = result;
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof IPluginModelBase) {
                            libraries.add((IPluginModelBase)o);
                        }
                        ++n2;
                    }
                    LibraryBundleLinkExecutor.this.addLibraries(LibraryBundleLinkExecutor.this.m_bundle, libraries);
                }
            }
        });
        return null;
    }

    protected void addLibraries(IScoutBundle b, Set<IPluginModelBase> libraries) {
        LibraryBundlesAddOperation addOp = new LibraryBundlesAddOperation(b, libraries);
        new OperationJob(new IOperation[]{addOp}).schedule();
    }

    protected IPluginModelBase[] getPotentialLibraryBundles(IScoutBundle b) {
        HashSet<String> alreadyLinkedLibraries = new HashSet<String>();
        PluginModelHelper helper = new PluginModelHelper(b.getProject());
        for (IPluginImport imp : helper.Manifest.getAllDependencies()) {
            alreadyLinkedLibraries.add(imp.getId());
        }
        IPluginModelBase[] workspaceModels = PluginRegistry.getWorkspaceModels();
        ArrayList<IPluginModelBase> plugins = new ArrayList<IPluginModelBase>(workspaceModels.length);
        IPluginModelBase[] iPluginModelBaseArray = workspaceModels;
        int n = workspaceModels.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project;
            IResource underlyingResource;
            IPluginModelBase bundle = iPluginModelBaseArray[n2];
            if (bundle instanceof IPluginModel && ResourceUtility.exists((IResource)(underlyingResource = bundle.getUnderlyingResource())) && (project = underlyingResource.getProject()) != null && project.exists()) {
                try {
                    if (project.isOpen() && project.hasNature("org.eclipse.scout.sdk.ScoutLibraryNature") && !alreadyLinkedLibraries.contains(project.getName())) {
                        plugins.add(bundle);
                    }
                }
                catch (CoreException e) {
                    ScoutSdkUi.logWarning("Could not determ library or not on '" + bundle.getBundleDescription().getName() + "'.", e);
                }
            }
            ++n2;
        }
        return plugins.toArray(new IPluginModelBase[plugins.size()]);
    }
}

