/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.bundle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.extensions.runtime.bundles.RuntimeBundles;
import org.eclipse.scout.sdk.ui.extensions.bundle.INewScoutBundleHandler;
import org.eclipse.scout.sdk.ui.extensions.bundle.IProductLauncherContributor;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ScoutBundleExtensionPoint {
    public static final String EXTENSION_ID = "scoutBundle";
    public static final String ATTRIBUTE_BUNDLE_ID = "id";
    public static final String ATTRIBUTE_BUNDLE_NAME = "bundleName";
    public static final String ATTRIBUTE_BUNDLE_TYPE = "bundleType";
    public static final String ATTRIBUTE_ORDER_NUMBER = "orderNumber";
    public static final String ATTRIBUTE_CLASS = "bundleNewHandler";
    public static final String ATTRIBUTE_PRODUCT_LAUNCHER_CONTRIB = "productLauncherContributor";
    public static final String ATTRIBUTE_BUNDLE_PAGE = "bundlePage";
    public static final String ATTRIBUTE_ICON = "icon";
    public static final String ATTRIBUTE_LAUNCHER_ICON = "launcherIcon";
    private static final Object LOCK = new Object();
    private static volatile Map<String, ScoutBundleUiExtension> allExtensions = null;

    private ScoutBundleExtensionPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ScoutBundleUiExtension> getAllExtensions() {
        if (allExtensions == null) {
            Object object = LOCK;
            synchronized (object) {
                if (allExtensions == null) {
                    IExtension[] extensions;
                    HashMap<String, ScoutBundleUiExtension> tmp = new HashMap<String, ScoutBundleUiExtension>();
                    IExtensionRegistry reg = Platform.getExtensionRegistry();
                    IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", EXTENSION_ID);
                    IExtension[] iExtensionArray = extensions = xp.getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement[] elements;
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            ScoutBundleUiExtension extensionPoint = new ScoutBundleUiExtension();
                            extensionPoint.setBundleId(element.getAttribute(ATTRIBUTE_BUNDLE_ID));
                            extensionPoint.setBundleName(element.getAttribute(ATTRIBUTE_BUNDLE_NAME));
                            try {
                                String launcherIcon;
                                String icon;
                                String bundlePage;
                                String contribPlugin = element.getContributor().getName();
                                extensionPoint.setNewScoutBundleHandler((INewScoutBundleHandler)element.createExecutableExtension(ATTRIBUTE_CLASS));
                                String productLauncherContributor = element.getAttribute(ATTRIBUTE_PRODUCT_LAUNCHER_CONTRIB);
                                if (StringUtility.hasText((CharSequence)productLauncherContributor)) {
                                    extensionPoint.setProductLauncherContributor((IProductLauncherContributor)element.createExecutableExtension(ATTRIBUTE_PRODUCT_LAUNCHER_CONTRIB));
                                }
                                if (!StringUtility.isNullOrEmpty((CharSequence)(bundlePage = StringUtility.trim((String)element.getAttribute(ATTRIBUTE_BUNDLE_PAGE))))) {
                                    try {
                                        Class loadClass = Platform.getBundle((String)contribPlugin).loadClass(bundlePage);
                                        extensionPoint.setBundlePageClass(loadClass);
                                    }
                                    catch (Exception e) {
                                        ScoutSdkUi.logError("Unable to load bundle page '" + bundlePage + "'.", e);
                                    }
                                }
                                if (StringUtility.hasText((CharSequence)(icon = element.getAttribute(ATTRIBUTE_ICON)))) {
                                    extensionPoint.setIcon(AbstractUIPlugin.imageDescriptorFromPlugin((String)contribPlugin, (String)icon));
                                }
                                if (StringUtility.hasText((CharSequence)(launcherIcon = element.getAttribute(ATTRIBUTE_LAUNCHER_ICON)))) {
                                    extensionPoint.setLauncherIconPath(AbstractUIPlugin.imageDescriptorFromPlugin((String)contribPlugin, (String)launcherIcon));
                                }
                                String attOrderNr = element.getAttribute(ATTRIBUTE_ORDER_NUMBER);
                                try {
                                    extensionPoint.setOrderNumber(Integer.parseInt(attOrderNr));
                                }
                                catch (NumberFormatException e) {
                                    ScoutSdkUi.logError("could not parse order number '" + attOrderNr + "' of extension '" + element.getNamespaceIdentifier() + "'.", e);
                                }
                                extensionPoint.setBundleType(element.getAttribute(ATTRIBUTE_BUNDLE_TYPE));
                                if (extensionPoint.isValidConfiguration()) {
                                    tmp.put(extensionPoint.getBundleType(), extensionPoint);
                                }
                            }
                            catch (CoreException e) {
                                ScoutSdkUi.logError("could not load class '" + element.getAttribute(ATTRIBUTE_CLASS) + "'.", e);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    allExtensions = CollectionUtility.copyMap(tmp);
                }
            }
        }
        return allExtensions;
    }

    public static List<ScoutBundleUiExtension> getExtensions() {
        ArrayList ret = CollectionUtility.arrayList(ScoutBundleExtensionPoint.getAllExtensions().values());
        Collections.sort(ret, new Comparator<ScoutBundleUiExtension>(){

            @Override
            public int compare(ScoutBundleUiExtension o1, ScoutBundleUiExtension o2) {
                return o1.getOrderNumber() - o2.getOrderNumber();
            }
        });
        return ret;
    }

    public static ScoutBundleUiExtension getExtension(String bundleType) {
        return ScoutBundleExtensionPoint.getAllExtensions().get(bundleType);
    }

    public static ScoutBundleUiExtension getExtension(IScoutBundle bundle) {
        ScoutBundleUiExtension extension = ScoutBundleExtensionPoint.getExtension(bundle.getType());
        if (extension != null) {
            return extension;
        }
        for (String type : RuntimeBundles.getReferencedTypes((String)bundle.getType())) {
            extension = ScoutBundleExtensionPoint.getAllExtensions().get(type);
            if (extension == null) continue;
            return extension;
        }
        return null;
    }
}

