/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.ui.extensions.preferences.AbstractScoutProjectPreferencePage;
import org.eclipse.scout.sdk.ui.extensions.preferences.DefaultSuperClassModel;
import org.eclipse.scout.sdk.ui.extensions.preferences.IScoutProjectScrolledContent;
import org.eclipse.scout.sdk.ui.extensions.preferences.SuperTypePreferenceScrolledContent;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class SuperTypesPreferencePage
extends AbstractScoutProjectPreferencePage<SuperTypePreferenceScrolledContent, DefaultSuperClassModel> {
    public SuperTypesPreferencePage() {
        super(Texts.get((String)"ScoutSDKSuperTypePreferences"), SuperTypePreferenceScrolledContent.class, "CLIENT", "SERVER", "SHARED");
    }

    @Override
    protected void loadAllModels(IScoutProjectScrolledContent.IModelLoadProgressObserver<DefaultSuperClassModel> observer, IProgressMonitor monitor) {
        for (Map.Entry e : this.getProjectModelMap().entrySet()) {
            if (monitor.isCanceled()) {
                return;
            }
            ArrayList<DefaultSuperClassModel> list = new ArrayList<DefaultSuperClassModel>();
            Set configuredClasses = RuntimeClasses.getAllDefaults((IScoutBundle)e.getKey()).entrySet();
            for (Map.Entry entry : configuredClasses) {
                list.add(new DefaultSuperClassModel((String)entry.getKey(), (String)entry.getValue(), e.getKey()));
            }
            Collections.sort(list);
            ((SuperTypePreferenceScrolledContent)e.getValue()).loadModel((List<DefaultSuperClassModel>)list, observer, monitor);
        }
    }

    @Override
    protected int getTotalWork() {
        int work = 0;
        for (IScoutBundle b : this.getProjectModelMap().keySet()) {
            work += RuntimeClasses.getAllDefaults((IScoutBundle)b).size();
        }
        return work;
    }
}

