/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.nls;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.SearchRangeStyledLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.graphics.Image;

public class NlsTextLabelProvider
extends SearchRangeStyledLabelProvider {
    private final INlsProject m_nlsProject;

    public NlsTextLabelProvider(INlsProject nlsProject) {
        this.m_nlsProject = nlsProject;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element == NlsTextProposal.NEW_NLS_TEXT_PROPOSAL) {
            return Texts.get((String)"Nls_newProposal_name");
        }
        if (element instanceof NlsTextProposal) {
            NlsTextProposal proposal = (NlsTextProposal)element;
            return proposal.getDisplayText();
        }
        if (element instanceof INlsEntry) {
            INlsEntry entry = (INlsEntry)element;
            String text = entry.getTranslation(entry.getProject().getDevelopmentLanguage(), true);
            if (!StringUtility.hasText((CharSequence)text)) {
                text = entry.getKey();
            }
            return text;
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element == NlsTextProposal.NEW_NLS_TEXT_PROPOSAL) {
            return ScoutSdkUi.getImage("text_add.png");
        }
        if (element instanceof NlsTextProposal) {
            NlsTextProposal p = (NlsTextProposal)element;
            switch (p.getMatchKind()) {
                case 1: {
                    return ScoutSdkUi.getImage("text.png");
                }
                case 2: {
                    return ScoutSdkUi.getImage("text_key.png");
                }
                case 4: {
                    return ScoutSdkUi.getImage("text_foreign.png");
                }
            }
        }
        return null;
    }

    public INlsProject getNlsProject() {
        return this.m_nlsProject;
    }

    @Override
    public boolean isFormatConcatString() {
        return false;
    }
}

