/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newbundle;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.project.AbstractProjectNewWizardPage;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ProductFileSelectionWizardPage
extends AbstractProjectNewWizardPage {
    private static final String PROP_SELECTED_PRODUCTS = "selectedProductFilesToModify";
    private final IScoutBundle m_scoutBundle;
    private CheckableTree m_bundleTree;

    public ProductFileSelectionWizardPage(IScoutBundle scoutBundle) {
        super(ProductFileSelectionWizardPage.class.getName());
        this.setTitle(Texts.get((String)"SelectProductsToModify"));
        this.setDescription(Texts.get((String)"ProductFileSelectionWizardMsg"));
        this.m_scoutBundle = scoutBundle;
    }

    @Override
    public void putProperties(PropertyMap properties) {
        ITreeNode[] checkedNodes = (ITreeNode[])this.getProperty(PROP_SELECTED_PRODUCTS);
        if (checkedNodes != null && checkedNodes.length > 0) {
            IFile[] prodFiles = new IFile[checkedNodes.length];
            int i = 0;
            while (i < checkedNodes.length) {
                prodFiles[i] = (IFile)checkedNodes[i].getData();
                ++i;
            }
            properties.setProperty("productFilesToExtend", (Object)prodFiles);
        }
    }

    @Override
    protected void createContent(Composite parent) {
        this.setExcludePage(true);
        try {
            ITreeNode root = TreeUtility.createProductTree(this.m_scoutBundle, null, true);
            ITreeNode[] productFileNodes = TreeUtility.findNodes(root, NodeFilters.getByType("zz_product_node"));
            this.m_bundleTree = new CheckableTree(parent, root);
            this.m_bundleTree.addCheckSelectionListener(new ICheckStateListener(){

                @Override
                public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                    ProductFileSelectionWizardPage.this.setProperty(ProductFileSelectionWizardPage.PROP_SELECTED_PRODUCTS, ProductFileSelectionWizardPage.this.m_bundleTree.getCheckedNodes());
                    ProductFileSelectionWizardPage.this.pingStateChanging();
                }
            });
            this.m_bundleTree.setChecked(productFileNodes);
            parent.setLayout((Layout)new GridLayout(1, true));
            this.m_bundleTree.setLayoutData(new GridData(1808));
            this.setExcludePage(productFileNodes.length < 1);
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("Unable to create product file tree", e);
        }
    }
}

