/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newproject;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.compatibility.PlatformVersionUtility;
import org.eclipse.scout.sdk.extensions.runtime.classes.IRuntimeClasses;
import org.eclipse.scout.sdk.operation.project.AbstractScoutProjectNewOperation;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleProposalProvider;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizard;
import org.eclipse.scout.sdk.ui.wizard.project.AbstractProjectNewWizardPage;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Version;

public class ScoutProjectNewWizardPage
extends AbstractProjectNewWizardPage
implements IScoutProjectWizardPage {
    private static final String TYPE_BUNDLE = "bundle";
    private static final String PROP_CURR_TARGET = "curr";
    private static final String PROP_RECOMMENDED_TARGET = "recomm";
    private static final String PROP_KEEP_CURRENT = "keep";
    private static final String PROP_PLATFORM_VERSION = "vers";
    protected StyledTextField m_projectNameField;
    protected StyledTextField m_postFixField;
    protected CheckableTree m_bundleTree;
    protected ITreeNode m_invisibleRootNode;
    protected ProposalTextField m_eclipseTargetPlatform;
    protected Button m_useDefaultScoutPreferences;
    protected StyledTextField m_projectAliasNameField;

    public ScoutProjectNewWizardPage() {
        super(ScoutProjectNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"CreateAScoutProject"));
        this.setDescription(Texts.get((String)"CreateScoutProjectHelpMsg"));
        this.setUseDefaultJdtPrefsInternal(true);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_projectNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"ProjectName"));
        this.m_projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.setProjectNameInternal(ScoutProjectNewWizardPage.this.m_projectNameField.getText());
                    ScoutProjectNewWizardPage.this.updateBundleNames();
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_postFixField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"ProjectPostfix"));
        this.m_postFixField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.setProjectNamePostfixInternal(ScoutProjectNewWizardPage.this.m_postFixField.getText());
                    ScoutProjectNewWizardPage.this.updateBundleNames();
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_invisibleRootNode = this.buildBundleTree();
        this.m_bundleTree = new CheckableTree(parent, this.m_invisibleRootNode);
        this.m_bundleTree.addCheckSelectionListener(new ICheckStateListener(){

            @Override
            public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                ScoutBundleUiExtension ext;
                ScoutProjectNewWizardPage.this.setProperty("selectedBundles", ScoutProjectNewWizardPage.this.m_bundleTree.getCheckedNodes());
                if (!node.isEnabled()) {
                    checkState = false;
                }
                if ((ext = (ScoutBundleUiExtension)node.getData()) != null) {
                    ext.getNewScoutBundleHandler().bundleSelectionChanged(ScoutProjectNewWizardPage.this.getWizard(), checkState);
                }
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_bundleTree.setChecked(TreeUtility.findNodes(this.m_invisibleRootNode, new P_InitialCheckNodesFilter()));
        for (ScoutBundleUiExtension e : ScoutBundleExtensionPoint.getExtensions()) {
            e.getNewScoutBundleHandler().init(this.getWizard(), e);
        }
        Control aliasGroup = this.createPropertiesGroup(parent);
        this.m_projectNameField.setFocus();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_projectNameField.setLayoutData(new GridData(768));
        this.m_postFixField.setLayoutData(new GridData(768));
        this.m_bundleTree.setLayoutData(new GridData(1808));
        aliasGroup.setLayoutData((Object)new GridData(768));
    }

    private ITreeNode buildBundleTree() {
        TreeNode rootNode = new TreeNode("root", "root");
        rootNode.setVisible(false);
        for (ScoutBundleUiExtension e : ScoutBundleExtensionPoint.getExtensions()) {
            TreeUtility.createNode(rootNode, TYPE_BUNDLE, e.getBundleName(), e.getIcon(), e.getOrderNumber(), e, false);
        }
        return rootNode;
    }

    private void updateBundleNames() {
        String pf;
        int dotIndex;
        ITreeNode[] iTreeNodeArray = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node = iTreeNodeArray[n2];
            ScoutBundleUiExtension ext = (ScoutBundleUiExtension)node.getData();
            if (ext != null && node.isEnabled()) {
                node.setText(AbstractScoutProjectNewOperation.getPluginName((String)this.getProjectName(), (String)this.getProjectNamePostfix(), (String)ext.getBundleName()));
            }
            ++n2;
        }
        this.m_bundleTree.getTreeViewer().refresh();
        String alias = "";
        if (this.getProjectName() != null && (dotIndex = this.getProjectName().lastIndexOf(46)) > 0 && dotIndex < this.getProjectName().length() - 1) {
            alias = this.getProjectName().substring(dotIndex + 1);
        }
        if ((pf = this.getProjectNamePostfix()) != null && (pf = pf.trim()).length() > 1) {
            alias = String.valueOf(alias) + NamingUtility.ensureStartWithUpperCase((String)pf);
        }
        this.m_projectAliasNameField.setText(alias);
    }

    protected SimpleProposal[] getTargetPlatformProposals() {
        String RECOMMENDED_VERSION = "3.8";
        String[][] supportedPlatforms = new String[][]{{"Indigo", "3.7"}, {"Juno", "3.8"}, {"Luna", "4.4"}, {"Mars", "4.5"}};
        ArrayList<SimpleProposal> ret = new ArrayList<SimpleProposal>(supportedPlatforms.length);
        String[][] stringArrayArray = supportedPlatforms;
        int n = supportedPlatforms.length;
        int n2 = 0;
        while (n2 < n) {
            String[] platform = stringArrayArray[n2];
            String codeName = platform[0];
            String ver = platform[1];
            boolean isCurrent = this.isCurrentPlatform(ver);
            boolean isRecommended = "3.8".equals(ver);
            StringBuilder txt = new StringBuilder("New Eclipse ");
            txt.append(codeName).append(" Target (").append(ver);
            if (isCurrent) {
                txt.append(", ").append(Texts.get((String)"current"));
            }
            if (isRecommended) {
                txt.append(", ").append(Texts.get((String)"recommended"));
            }
            txt.append(")");
            SimpleProposal prop = new SimpleProposal(txt.toString(), null);
            prop.setData(PROP_CURR_TARGET, isCurrent);
            prop.setData(PROP_RECOMMENDED_TARGET, isRecommended);
            prop.setData(PROP_PLATFORM_VERSION, ver);
            prop.setData(PROP_KEEP_CURRENT, Boolean.FALSE);
            ret.add(prop);
            ++n2;
        }
        if (JdtUtility.getNewestBundleInActiveTargetPlatform((String)IRuntimeClasses.ScoutClientBundleId) != null && JdtUtility.getNewestBundleInActiveTargetPlatform((String)IRuntimeClasses.ScoutServerBundleId) != null && JdtUtility.getNewestBundleInActiveTargetPlatform((String)IRuntimeClasses.ScoutSharedBundleId) != null && JdtUtility.getNewestBundleInActiveTargetPlatform((String)IRuntimeClasses.ScoutUiSwingBundleId) != null && JdtUtility.getNewestBundleInActiveTargetPlatform((String)IRuntimeClasses.ScoutUiSwtBundleId) != null) {
            String ver = null;
            Version targetPlatformVersion = JdtUtility.getTargetPlatformVersion();
            ver = targetPlatformVersion == null ? "3.8" : String.valueOf(targetPlatformVersion.getMajor()) + "." + targetPlatformVersion.getMinor();
            SimpleProposal prop = new SimpleProposal(Texts.get((String)"KeepCurrentTarget", (String[])new String[]{ver}), null);
            prop.setData(PROP_CURR_TARGET, Boolean.FALSE);
            prop.setData(PROP_RECOMMENDED_TARGET, Boolean.FALSE);
            prop.setData(PROP_KEEP_CURRENT, Boolean.TRUE);
            prop.setData(PROP_PLATFORM_VERSION, ver);
            ret.add(prop);
        }
        return ret.toArray(new SimpleProposal[ret.size()]);
    }

    protected boolean isCurrentPlatform(String ver) {
        String curPlatform = PlatformVersionUtility.getPlatformVersion().toString();
        return curPlatform.startsWith(ver);
    }

    protected void setTargetPlatformDefaultSelection(SimpleProposal[] targetPlatformProposals) {
        SimpleProposal recommended = null;
        SimpleProposal current = null;
        SimpleProposal[] simpleProposalArray = targetPlatformProposals;
        int n = targetPlatformProposals.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean curr;
            SimpleProposal p = simpleProposalArray[n2];
            Boolean reco = (Boolean)p.getData(PROP_RECOMMENDED_TARGET);
            if (reco.booleanValue()) {
                recommended = p;
            }
            if ((curr = (Boolean)p.getData(PROP_CURR_TARGET)).booleanValue()) {
                current = p;
            }
            ++n2;
        }
        if (current != null) {
            this.m_eclipseTargetPlatform.acceptProposal(current);
            this.setTargetPlatformVersionInternal((String)current.getData(PROP_PLATFORM_VERSION));
        } else if (recommended != null) {
            this.m_eclipseTargetPlatform.acceptProposal(recommended);
            this.setTargetPlatformVersionInternal((String)recommended.getData(PROP_PLATFORM_VERSION));
        }
    }

    protected Control createPropertiesGroup(Composite parent) {
        Group group = new Group(parent, 4);
        group.setText(Texts.get((String)"ProjectProperties"));
        SimpleProposal[] targetPlatformProposals = this.getTargetPlatformProposals();
        SimpleProposalProvider provider = new SimpleProposalProvider(targetPlatformProposals);
        this.m_eclipseTargetPlatform = this.getFieldToolkit().createProposalField((Composite)group, Texts.get((String)"EclipsePlatform"), 0);
        this.m_eclipseTargetPlatform.setContentProvider(provider);
        this.m_eclipseTargetPlatform.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider());
        this.m_eclipseTargetPlatform.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SimpleProposal proposal = (SimpleProposal)event.proposal;
                if (proposal != null) {
                    ScoutProjectNewWizardPage.this.setTargetPlatformVersionInternal((String)proposal.getData(ScoutProjectNewWizardPage.PROP_PLATFORM_VERSION));
                    Object keepCurrent = proposal.getData(ScoutProjectNewWizardPage.PROP_KEEP_CURRENT);
                    if (keepCurrent instanceof Boolean) {
                        ScoutProjectNewWizardPage.this.setKeepCurrentTarget((Boolean)keepCurrent);
                    } else {
                        ScoutProjectNewWizardPage.this.setKeepCurrentTarget(false);
                    }
                } else {
                    ScoutProjectNewWizardPage.this.setTargetPlatformVersionInternal(null);
                    ScoutProjectNewWizardPage.this.setKeepCurrentTarget(false);
                }
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        this.setTargetPlatformDefaultSelection(targetPlatformProposals);
        Composite prefButton = this.createPreferencesButton((Composite)group);
        this.m_projectAliasNameField = this.getFieldToolkit().createStyledTextField((Composite)group, Texts.get((String)"ProjectAlias"));
        this.m_projectAliasNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScoutProjectNewWizardPage.this.setProjectAliasInternal(ScoutProjectNewWizardPage.this.m_projectAliasNameField.getText());
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        Composite infoLabel = this.createInfoLabel((Composite)group);
        group.setLayout((Layout)new GridLayout(1, true));
        infoLabel.setLayoutData((Object)new GridData(768));
        this.m_eclipseTargetPlatform.setLayoutData(new GridData(768));
        this.m_projectAliasNameField.setLayoutData(new GridData(768));
        prefButton.setLayoutData((Object)new GridData(768));
        return group;
    }

    protected Composite createPreferencesButton(Composite p) {
        Composite parent = new Composite(p, 0);
        Label lbl = new Label(parent, 0);
        parent.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(20, 0);
        labelData.bottom = new FormAttachment(100, 0);
        lbl.setLayoutData((Object)labelData);
        this.m_useDefaultScoutPreferences = new Button(parent, 32);
        this.m_useDefaultScoutPreferences.setText(Texts.get((String)"UseDefaultScoutJDTPreferences"));
        this.m_useDefaultScoutPreferences.setSelection(this.isUseDefaultJdtPrefs());
        this.m_useDefaultScoutPreferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScoutProjectNewWizardPage.this.setUseDefaultJdtPrefsInternal(ScoutProjectNewWizardPage.this.m_useDefaultScoutPreferences.getSelection());
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)lbl, 5);
        textData.right = new FormAttachment(100, 0);
        textData.bottom = new FormAttachment(100, 0);
        this.m_useDefaultScoutPreferences.setLayoutData((Object)textData);
        return parent;
    }

    protected Composite createInfoLabel(Composite p) {
        Composite parent = new Composite(p, 0);
        Label lbl = new Label(parent, 0);
        parent.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(20, 0);
        labelData.bottom = new FormAttachment(100, 0);
        lbl.setLayoutData((Object)labelData);
        Label label = new Label(parent, 0);
        label.setText(Texts.get((String)"ProjectAliasHelp"));
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)lbl, 5);
        textData.right = new FormAttachment(100, 0);
        textData.bottom = new FormAttachment(100, 0);
        label.setLayoutData((Object)textData);
        return parent;
    }

    @Override
    public void putProperties(PropertyMap properties) {
        String postfix = this.getProjectNamePostfix();
        if (postfix != null && (postfix = postfix.trim()).length() == 0) {
            postfix = null;
        }
        properties.setProperty("GROUP", (Object)this.getProjectName().trim());
        properties.setProperty("POSTFIX", (Object)postfix);
        properties.setProperty("ALIAS", (Object)this.getProjectAlias().trim());
        properties.setProperty("TARGET_PLATFORM_VERSION", (Object)new Version(this.getTargetPlatformVersion()));
        properties.setProperty("PROP_USE_DEFAULT_JDT_PREFS", (Object)this.isUseDefaultJdtPrefs());
        properties.setProperty("KEEP_CURRENT_TARGET", (Object)this.isKeepCurrentTarget());
        ITreeNode[] nodes = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getAcceptAll());
        HashSet<String> checkedNodeExtensionIds = new HashSet<String>(nodes.length);
        ITreeNode[] iTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node = iTreeNodeArray[n2];
            ScoutBundleUiExtension ext = (ScoutBundleUiExtension)node.getData();
            if (ext != null) {
                if (this.m_bundleTree.isChecked(node) && node.isEnabled() && node.isVisible()) {
                    checkedNodeExtensionIds.add(ext.getBundleId());
                }
                ext.getNewScoutBundleHandler().putProperties(this.getWizard(), properties);
            }
            ++n2;
        }
        properties.setProperty("CHECKED_NODES", checkedNodeExtensionIds);
    }

    public void performHelp() {
        ResourceUtility.showUrlInBrowser((String)"https://wiki.eclipse.org/Scout/HowTo/5.0/Create_a_new_project#Step_1");
    }

    public ScoutProjectNewWizard getWizard() {
        return (ScoutProjectNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusProjectName());
        multiStatus.add(this.getStatusProjectPostfix());
        multiStatus.add(this.getStatusProjectAlias());
        multiStatus.add(this.getStatusTargetPlatform());
        multiStatus.add(this.getStatusTargetProject());
        ITreeNode[] iTreeNodeArray = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutBundleUiExtension ext;
            ITreeNode node = iTreeNodeArray[n2];
            if (this.m_bundleTree.isChecked(node) && (ext = (ScoutBundleUiExtension)node.getData()) != null) {
                multiStatus.add(ext.getNewScoutBundleHandler().getStatus(this.getWizard()));
            }
            ++n2;
        }
    }

    protected IStatus getStatusTargetPlatform() {
        if (StringUtility.isNullOrEmpty((CharSequence)this.getTargetPlatformVersion())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"PleaseChooseATargetPlatform"));
        }
        SimpleProposal p = (SimpleProposal)this.m_eclipseTargetPlatform.getSelectedProposal();
        boolean keepCurrent = (Boolean)p.getData(PROP_KEEP_CURRENT);
        if (keepCurrent) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheCurrentlyActiveTargetPlatformWillBeUsed"));
        }
        boolean isCurrent = (Boolean)p.getData(PROP_CURR_TARGET);
        if (!isCurrent) {
            return new Status(1, "org.eclipse.scout.sdk.ui", Texts.get((String)"ACompleteEclipsePlatformWillBeDownloaded"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusProjectPostfix() {
        if (StringUtility.isNullOrEmpty((CharSequence)this.getProjectNamePostfix())) {
            return Status.OK_STATUS;
        }
        if (this.getProjectNamePostfix().matches("[a-zA-Z]{1}[a-zA-Z0-9]*[a-zA-Z]{1}")) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ProjectPostfixIsNotValid"));
    }

    protected IStatus getStatusTargetProject() {
        String targetPluginName = AbstractScoutProjectNewOperation.getPluginName((String)this.getProjectName(), (String)this.getProjectNamePostfix(), (String)".target");
        return ScoutUtility.validateNewBundleName((String)targetPluginName);
    }

    protected IStatus getStatusProjectName() {
        ITreeNode[] iTreeNodeArray = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus s;
            ITreeNode node = iTreeNodeArray[n2];
            if (node.isEnabled() && this.m_bundleTree.isChecked(node) && !(s = ScoutUtility.validateNewBundleName((String)node.getText())).isOK()) {
                return s;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusProjectAlias() {
        if (StringUtility.isNullOrEmpty((CharSequence)this.getProjectAlias())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ProjectAliasMissing"));
        }
        if (this.getProjectAlias().matches("[a-zA-Z]{1}[a-zA-Z0-9]*[a-zA-Z]{1}")) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", "Project alias is not valid.");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
    }

    @Override
    public boolean isBundleNodesSelected(String ... extensionIds) {
        ITreeNode[] nodes;
        ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, new P_NodeByExtensionIdFilter(extensionIds));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            if (!this.m_bundleTree.isChecked(n3)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void setBundleNodeSelected(boolean selected, String ... extensionIds) {
        ITreeNode[] nodes;
        ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, new P_NodeByExtensionIdFilter(extensionIds));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            this.m_bundleTree.setChecked(n3, selected);
            ++n2;
        }
    }

    @Override
    public void setBundleNodeAvailable(boolean enabled, boolean visible, String ... extensionIds) {
        ITreeNode[] nodes;
        ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, new P_NodeByExtensionIdFilter(extensionIds));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            n3.setEnabled(enabled);
            n3.setVisible(visible);
            ++n2;
        }
    }

    @Override
    public boolean hasSelectedBundle(String ... types) {
        ITreeNode[] nodes;
        ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, new P_NodeByBundleTypeFilter(types));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            if (this.m_bundleTree.isChecked(n3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getTargetPlatformVersion() {
        return this.getPropertyString("eclipseTargetPlatform");
    }

    private void setTargetPlatformVersionInternal(String version) {
        this.setPropertyString("eclipseTargetPlatform", version);
    }

    public boolean isKeepCurrentTarget() {
        return this.getPropertyBool("keepCurrentTarget");
    }

    private void setKeepCurrentTarget(boolean v) {
        this.setPropertyBool("keepCurrentTarget", v);
    }

    @Override
    public String getProjectName() {
        return this.getPropertyString("projectName");
    }

    public void setProjectName(String projectName) {
        try {
            this.setStateChanging(true);
            this.setProjectNameInternal(projectName);
            if (this.isControlCreated()) {
                this.m_projectNameField.setText(projectName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setProjectNameInternal(String projectName) {
        this.setPropertyString("projectName", projectName);
    }

    @Override
    public String getProjectNamePostfix() {
        return this.getPropertyString("projectNamePostfix");
    }

    public void setProjectNamePostfix(String projectPostfix) {
        try {
            this.setStateChanging(true);
            this.setProjectNamePostfixInternal(projectPostfix);
            if (this.isControlCreated()) {
                this.m_postFixField.setText(projectPostfix);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setProjectNamePostfixInternal(String projectPostfix) {
        this.setPropertyString("projectNamePostfix", projectPostfix);
    }

    @Override
    public String getProjectAlias() {
        return this.getPropertyString("projectAlias");
    }

    public void setProjectAlias(String projectAlias) {
        try {
            this.setStateChanging(true);
            this.setProjectAliasInternal(projectAlias);
            if (this.isControlCreated()) {
                this.m_projectAliasNameField.setText(projectAlias);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setProjectAliasInternal(String alias) {
        this.setPropertyString("projectAlias", alias);
    }

    public boolean isUseDefaultJdtPrefs() {
        return this.getPropertyBool("useDefaultJdtPrefs");
    }

    public void setUseDefaultJdtPrefs(boolean useDefaultJdtPrefs) {
        try {
            this.setStateChanging(true);
            this.setUseDefaultJdtPrefsInternal(useDefaultJdtPrefs);
            if (this.isControlCreated()) {
                this.m_useDefaultScoutPreferences.setSelection(useDefaultJdtPrefs);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setUseDefaultJdtPrefsInternal(boolean useDefaultJdtPrefs) {
        this.setPropertyBool("useDefaultJdtPrefs", useDefaultJdtPrefs);
    }

    private class P_InitialCheckNodesFilter
    implements ITreeNodeFilter {
        private P_InitialCheckNodesFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            return ScoutProjectNewWizardPage.TYPE_BUNDLE.equals(node.getType());
        }
    }

    private class P_NodeByBundleTypeFilter
    implements ITreeNodeFilter {
        private final HashSet<String> m_types = new HashSet();

        public P_NodeByBundleTypeFilter(String ... types) {
            if (types != null) {
                String[] stringArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.m_types.add(s);
                    ++n2;
                }
            }
        }

        @Override
        public boolean accept(ITreeNode node) {
            ScoutBundleUiExtension extension = (ScoutBundleUiExtension)node.getData();
            if (extension != null) {
                return this.m_types.contains(extension.getBundleType());
            }
            return false;
        }
    }

    private class P_NodeByExtensionIdFilter
    implements ITreeNodeFilter {
        private final HashSet<String> m_ids = new HashSet();

        public P_NodeByExtensionIdFilter(String ... extensionIds) {
            if (extensionIds != null) {
                String[] stringArray = extensionIds;
                int n = extensionIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.m_ids.add(s);
                    ++n2;
                }
            }
        }

        @Override
        public boolean accept(ITreeNode node) {
            ScoutBundleUiExtension extension = (ScoutBundleUiExtension)node.getData();
            if (extension != null) {
                return this.m_ids.contains(extension.getBundleId());
            }
            return false;
        }
    }
}

