/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages;

import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.jdt.compile.ScoutSeverityManager;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.action.rename.TypeRenameAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyProvider;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractScoutTypePage
extends AbstractPage
implements ITypePage {
    private IType m_type;
    private final String m_readOnlySuffix;

    public AbstractScoutTypePage() {
        this(null);
    }

    public AbstractScoutTypePage(String readOnlySuffix) {
        this.m_readOnlySuffix = readOnlySuffix;
    }

    @Override
    public void setType(IType type) {
        this.m_type = type;
        String methodNameForTranslatedText = this.getMethodNameForTranslatedText();
        this.setName(PropertyMethodSourceUtility.getTranslatedMethodStringValue((IType)this.getType(), (String)methodNameForTranslatedText));
    }

    @Override
    public IType getType() {
        return this.m_type;
    }

    public String getReadOnlySuffix() {
        return this.m_readOnlySuffix;
    }

    protected ITypeHierarchy getLocalHierarchy() {
        IPage p = this;
        while (p != null) {
            if (p instanceof ITypeHierarchyProvider) {
                return ((ITypeHierarchyProvider)p).getTypeHierarchy();
            }
            p = p.getParent();
        }
        return TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{this.getType()});
    }

    protected String getMethodNameForTranslatedText() {
        return null;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public int getQuality() {
        int quality = 0;
        if (TypeUtility.exists((IJavaElement)this.getType())) {
            quality = ScoutSeverityManager.getInstance().getSeverityOf((Object)this.getType());
        }
        return quality;
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(TypeRenameAction.class, ShowJavaReferencesAction.class);
    }

    @Override
    public boolean handleDoubleClickedDelegate() {
        try {
            ITextEditor textEditor;
            IRegion reg;
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)this.getType());
            if (editor instanceof ITextEditor && (reg = (textEditor = (ITextEditor)editor).getHighlightRange()) != null) {
                textEditor.setHighlightRange(reg.getOffset(), reg.getLength(), true);
            }
            return true;
        }
        catch (Exception ex) {
            ScoutSdkUi.logWarning(ex);
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        IType type = this.getType();
        if (type != null) {
            hash += 31 * hash + type.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (!equals) {
            return false;
        }
        if (!(obj instanceof AbstractScoutTypePage)) {
            return false;
        }
        return CompareUtility.equals((Object)this.getType(), (Object)((AbstractScoutTypePage)obj).getType());
    }
}

