/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;

public final class CachedPrimaryTypeHierarchy
implements ICachedTypeHierarchy {
    private final ICachedTypeHierarchy m_cachedTypeHierarchy;

    CachedPrimaryTypeHierarchy(ICachedTypeHierarchy cachedTypeHierarchy) {
        this.m_cachedTypeHierarchy = cachedTypeHierarchy;
    }

    @Override
    public IType getSuperclass(IType type) {
        if (CachedPrimaryTypeHierarchy.isPrimary(type)) {
            return this.m_cachedTypeHierarchy.getSuperclass(type);
        }
        return null;
    }

    private static boolean isPrimary(IType t) {
        return TypeFilters.getPrimaryTypeFilter().accept(t);
    }

    @Override
    public boolean isSubtype(IType type, IType potentialSubtype) {
        if (CompareUtility.equals((Object)type, (Object)potentialSubtype)) {
            return true;
        }
        if (!CachedPrimaryTypeHierarchy.isPrimary(type) || !CachedPrimaryTypeHierarchy.isPrimary(potentialSubtype)) {
            return false;
        }
        return this.m_cachedTypeHierarchy.isSubtype(type, potentialSubtype);
    }

    @Override
    public boolean contains(IType type) {
        if (!CachedPrimaryTypeHierarchy.isPrimary(type)) {
            return false;
        }
        return this.m_cachedTypeHierarchy.contains(type);
    }

    protected ITypeFilter getPrimaryTypeFilter(ITypeFilter existingFilter) {
        if (existingFilter == null) {
            return TypeFilters.getPrimaryTypeFilter();
        }
        return TypeFilters.getMultiTypeFilterAnd(TypeFilters.getPrimaryTypeFilter(), existingFilter);
    }

    @Override
    public Set<IType> getAllSubtypes(IType type) {
        return this.getAllSubtypes(type, null);
    }

    @Override
    public Set<IType> getAllSubtypes(IType type, ITypeFilter filter) {
        return this.getAllSubtypes(type, filter, null);
    }

    @Override
    public Set<IType> getAllSubtypes(IType type, ITypeFilter filter, Comparator<IType> typeComparator) {
        return this.m_cachedTypeHierarchy.getAllSubtypes(type, this.getPrimaryTypeFilter(filter), typeComparator);
    }

    @Override
    public Set<IType> getAllClasses() {
        return this.getAllClasses(null);
    }

    @Override
    public Set<IType> getAllClasses(ITypeFilter filter) {
        return this.getAllClasses(filter, null);
    }

    @Override
    public Set<IType> getAllClasses(ITypeFilter filter, Comparator<IType> comparator) {
        return this.m_cachedTypeHierarchy.getAllClasses(this.getPrimaryTypeFilter(filter), comparator);
    }

    @Override
    public Set<IType> getAllInterfaces() {
        return this.getAllInterfaces(null);
    }

    @Override
    public Set<IType> getAllInterfaces(ITypeFilter filter) {
        return this.getAllInterfaces(filter, null);
    }

    @Override
    public Set<IType> getAllInterfaces(ITypeFilter filter, Comparator<IType> comparator) {
        return this.m_cachedTypeHierarchy.getAllInterfaces(this.getPrimaryTypeFilter(filter), comparator);
    }

    @Override
    public Set<IType> getAllSuperclasses(IType type) {
        return this.getAllSuperclasses(type, null);
    }

    @Override
    public Set<IType> getAllSuperclasses(IType type, ITypeFilter filter) {
        return this.getAllSuperclasses(type, filter, null);
    }

    @Override
    public Set<IType> getAllSuperclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        return this.m_cachedTypeHierarchy.getAllSuperclasses(type, this.getPrimaryTypeFilter(filter), comparator);
    }

    @Override
    public Set<IType> getAllSuperInterfaces(IType type) {
        return this.getAllSuperInterfaces(type, null);
    }

    @Override
    public Set<IType> getAllSuperInterfaces(IType type, ITypeFilter filter) {
        return this.getAllSuperInterfaces(type, filter, null);
    }

    @Override
    public Set<IType> getAllSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        return this.m_cachedTypeHierarchy.getAllSuperInterfaces(type, this.getPrimaryTypeFilter(filter), comparator);
    }

    @Override
    public Set<IType> getAllSupertypes(IType type) {
        return this.getAllSupertypes(type, null);
    }

    @Override
    public Set<IType> getAllSupertypes(IType type, ITypeFilter filter) {
        return this.getAllSupertypes(type, filter, null);
    }

    @Override
    public Set<IType> getAllSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        return this.m_cachedTypeHierarchy.getAllSupertypes(type, this.getPrimaryTypeFilter(filter), comparator);
    }

    @Override
    public Set<IType> getSubclasses(IType type) {
        return this.getSubclasses(type, null);
    }

    @Override
    public Set<IType> getSubclasses(IType type, ITypeFilter filter) {
        return this.getSubclasses(type, filter, null);
    }

    @Override
    public Set<IType> getSubclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        return this.m_cachedTypeHierarchy.getSubclasses(type, this.getPrimaryTypeFilter(filter), comparator);
    }

    @Override
    public Set<IType> getSubtypes(IType type) {
        return this.getSubtypes(type, null);
    }

    @Override
    public Set<IType> getSubtypes(IType type, ITypeFilter filter) {
        return this.getSubtypes(type, filter, null);
    }

    @Override
    public Set<IType> getSubtypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        return this.m_cachedTypeHierarchy.getSubtypes(type, this.getPrimaryTypeFilter(filter), comparator);
    }

    @Override
    public Set<IType> getSuperInterfaces(IType type) {
        return this.getSuperInterfaces(type, null);
    }

    @Override
    public Set<IType> getSuperInterfaces(IType type, ITypeFilter filter) {
        return this.getSuperInterfaces(type, filter, null);
    }

    @Override
    public Set<IType> getSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        return this.m_cachedTypeHierarchy.getSuperInterfaces(type, this.getPrimaryTypeFilter(filter), comparator);
    }

    @Override
    public Set<IType> getSupertypes(IType type) {
        return this.getSupertypes(type, null);
    }

    @Override
    public Set<IType> getSupertypes(IType type, ITypeFilter filter) {
        return this.getSupertypes(type, filter, null);
    }

    @Override
    public Set<IType> getSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        return this.m_cachedTypeHierarchy.getSupertypes(type, this.getPrimaryTypeFilter(filter), comparator);
    }

    @Override
    public Set<IType> getAllTypes() {
        return this.getAllTypes(null);
    }

    @Override
    public Set<IType> getAllTypes(ITypeFilter filter) {
        return this.getAllTypes(filter, null);
    }

    @Override
    public Set<IType> getAllTypes(ITypeFilter filter, Comparator<IType> comparator) {
        return this.m_cachedTypeHierarchy.getAllTypes(this.getPrimaryTypeFilter(filter), comparator);
    }

    @Override
    public IType getBaseType() {
        return this.m_cachedTypeHierarchy.getBaseType();
    }

    @Override
    public Iterator<IType> iterator() {
        return this.m_cachedTypeHierarchy.iterator();
    }

    @Override
    public Deque<IType> getSuperClassStack(IType startType) {
        return this.m_cachedTypeHierarchy.getSuperClassStack(startType);
    }

    @Override
    public Deque<IType> getSuperClassStack(IType startType, boolean includeStartType) {
        return this.m_cachedTypeHierarchy.getSuperClassStack(startType, includeStartType);
    }

    @Override
    public Deque<IType> getSuperClassStack(IType startType, boolean includeStartType, String stopTypeFqn) {
        return this.m_cachedTypeHierarchy.getSuperClassStack(startType, includeStartType, stopTypeFqn);
    }

    @Override
    public void addHierarchyListener(ITypeHierarchyChangedListener listener) {
        this.m_cachedTypeHierarchy.addHierarchyListener(listener);
    }

    @Override
    public void removeHierarchyListener(ITypeHierarchyChangedListener listener) {
        this.m_cachedTypeHierarchy.removeHierarchyListener(listener);
    }

    @Override
    public void invalidate() {
        this.m_cachedTypeHierarchy.invalidate();
    }
}

