/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.internal.typecache.AbstractCachedTypeHierarchy;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;

public final class CachedTypeHierarchy
extends AbstractCachedTypeHierarchy {
    CachedTypeHierarchy(IType type) {
        super(type);
    }

    @Override
    public boolean isTypeAccepted(IType candidate, Set<IType> candidateSuperTypes) {
        return candidateSuperTypes.contains(this.getBaseType());
    }

    @Override
    protected void revalidate() {
        String msg = "Unable to create type hierarchy for type ";
        try {
            this.revalidateImpl();
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logError(String.valueOf(msg) + this.getBaseType().getFullyQualifiedName(), e);
        }
        catch (IllegalArgumentException e) {
            try {
                JdtUtility.waitForIndexesReady();
                this.revalidateImpl();
            }
            catch (JavaModelException e1) {
                SdkUtilActivator.logError(String.valueOf(msg) + this.getBaseType().getFullyQualifiedName(), e1);
            }
        }
    }

    private void revalidateImpl() throws JavaModelException {
        this.setJdtHierarchy(this.getBaseType().newTypeHierarchy(null));
    }
}

