/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.pde;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.product.WorkspaceProductModel;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.FormatPreservingProperties;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;

public final class LazyProductFileModel {
    private static final Pattern FRAGMENT_PATTERN = Pattern.compile("^(\\sfragment\\=\\\")([^\\\"]*)(\\\")");
    private final IFile m_productFile;
    private volatile WorkspaceProductModel m_productModel;
    private volatile IConfigurationFileInfo m_configFileInfo;
    private volatile FormatPreservingProperties m_configFileProperties;
    private volatile IFile m_configIniFile;

    public LazyProductFileModel(IFile productFile) {
        if (productFile == null) {
            throw new IllegalArgumentException("null product file not allowed.");
        }
        if (!productFile.exists()) {
            throw new IllegalArgumentException("invalid product file passed: '" + productFile.getFullPath().toString() + "'.");
        }
        this.m_productFile = productFile;
    }

    public synchronized WorkspaceProductModel getWorkspaceProductModel() throws CoreException {
        if (this.m_productModel == null) {
            WorkspaceProductModel tmp = new WorkspaceProductModel(this.m_productFile, true);
            tmp.load();
            tmp.setDirty(false);
            this.m_productModel = tmp;
        }
        return this.m_productModel;
    }

    public synchronized IConfigurationFileInfo getConfigurationFileInfo() throws CoreException {
        if (this.m_configFileInfo == null) {
            this.m_configFileInfo = this.getWorkspaceProductModel().getProduct().getConfigurationFileInfo();
        }
        return this.m_configFileInfo;
    }

    public synchronized IFile getConfigIniFile() throws CoreException {
        String osPath;
        if (this.m_configIniFile == null && StringUtility.hasText((CharSequence)(osPath = this.getConfigurationFileInfo().getPath(Platform.getOS())))) {
            IFile configIniFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(osPath.trim()));
            if (ResourceUtility.exists((IResource)configIniFile)) {
                this.m_configIniFile = configIniFile;
            } else {
                throw new CoreException((IStatus)new ScoutStatus("could not find product configuration file: " + osPath));
            }
        }
        return this.m_configIniFile;
    }

    public synchronized FormatPreservingProperties getConfigFileProperties() throws CoreException {
        if (this.m_configFileProperties == null) {
            FormatPreservingProperties tmp = new FormatPreservingProperties();
            IFile configIni = this.getConfigIniFile();
            if (configIni != null) {
                tmp.load(configIni);
            }
            this.m_configFileProperties = tmp;
        }
        return this.m_configFileProperties;
    }

    public synchronized void save() throws CoreException {
        if (this.m_productModel != null && this.m_productModel.isDirty()) {
            this.saveProductModel();
        }
        if (this.m_configFileProperties != null && this.m_configFileProperties.isDirty()) {
            this.saveConfigIni();
        }
    }

    private void saveConfigIni() throws CoreException {
        IFile configIni = this.getConfigIniFile();
        if (configIni == null) {
            return;
        }
        OutputStream stream = null;
        try {
            try {
                stream = new BufferedOutputStream(new FileOutputStream(configIni.getRawLocation().toFile()));
                this.m_configFileProperties.store(stream);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new ScoutStatus("unable to save product configuration file: " + configIni.getRawLocation().toOSString(), e));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            configIni.refreshLocal(0, null);
        }
    }

    private void saveProductModel() throws CoreException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        PrintWriter writer = new PrintWriter(out, false){

            @Override
            public void print(String s) {
                Matcher matcher = FRAGMENT_PATTERN.matcher(s);
                if (matcher.matches() && StringUtility.isNullOrEmpty((CharSequence)matcher.group(2))) {
                    return;
                }
                super.print(s);
            }
        };
        this.m_productModel.save(writer);
        writer.flush();
        writer.close();
        IFile file = (IFile)this.m_productModel.getUnderlyingResource();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        file.setContents((InputStream)in, true, false, null);
        file.refreshLocal(1, null);
    }
}

