/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.executor;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderHandlerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;

public class HandlerChainNewExecutor
extends AbstractExecutor {
    private IScoutBundle m_bundle;

    public boolean canRun(IStructuredSelection selection) {
        this.m_bundle = UiUtility.getScoutBundleFromSelection((IStructuredSelection)selection);
        return this.isEditable(this.m_bundle);
    }

    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        SunJaxWsBean sunJaxWsBean = null;
        Object el = selection.getFirstElement();
        if (!(el instanceof WebServiceProviderHandlerNodePage)) {
            return null;
        }
        sunJaxWsBean = ((WebServiceProviderHandlerNodePage)el).getSunJaxWsBean();
        String handlerChainsQName = sunJaxWsBean.toQualifiedName("handler-chains");
        Element xmlHandlerChains = JaxWsSdkUtility.getChildElement(sunJaxWsBean.getXml().getChildNodes(), handlerChainsQName);
        if (xmlHandlerChains == null) {
            xmlHandlerChains = sunJaxWsBean.getXml().getOwnerDocument().createElementNS("http://java.sun.com/xml/ns/javaee", handlerChainsQName);
            sunJaxWsBean.getXml().appendChild(xmlHandlerChains);
        }
        Element xmlHandlerChain = xmlHandlerChains.getOwnerDocument().createElement(sunJaxWsBean.toQualifiedName("handler-chain"));
        xmlHandlerChains.appendChild(xmlHandlerChain);
        ResourceFactory.getSunJaxWsResource(this.m_bundle).storeXmlAsync(xmlHandlerChain.getOwnerDocument(), 512, sunJaxWsBean.getAlias());
        return null;
    }
}

