/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.IResourceListener;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.ConsumerNewWizardAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceConsumerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class WebServiceConsumerTablePage
extends AbstractPage {
    private IScoutBundle m_bundle;
    private ICachedTypeHierarchy m_hierarchy;
    private ITypeHierarchyChangedListener m_hierarchyChangedListener;
    private IResourceListener m_resourceListener;

    public WebServiceConsumerTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get("Services"));
        this.setImageDescriptor(JaxWsSdk.getImageDescriptor("webservice_folder.png"));
        this.m_bundle = this.getScoutBundle();
        this.m_hierarchyChangedListener = new P_TypeHierarchyChangedListener();
        this.m_hierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient"));
        this.m_hierarchy.addHierarchyListener(this.m_hierarchyChangedListener);
        this.m_resourceListener = new P_BuildJaxWsResourceListener();
        this.getBuildJaxWsResource().addResourceListener(4, this.m_resourceListener);
        this.getBuildJaxWsResource().addResourceListener("", this.m_resourceListener);
    }

    public String getPageId() {
        return IJaxWsPageConstants.WEBSERVICE_CONSUMER_TABLE_PAGE;
    }

    public void unloadPage() {
        if (this.m_hierarchy != null && this.m_hierarchyChangedListener != null) {
            this.m_hierarchy.removeHierarchyListener(this.m_hierarchyChangedListener);
        }
        this.getBuildJaxWsResource().removeResourceListener(this.m_resourceListener);
        super.unloadPage();
    }

    public boolean isFolder() {
        return true;
    }

    public void refresh(boolean clearCache) {
        if (clearCache) {
            this.m_hierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(new Class[]{ConsumerNewWizardAction.class});
    }

    protected void loadChildrenImpl() {
        Set wsConsumerTypes = this.m_hierarchy.getAllSubtypes(TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient"), ScoutTypeFilters.getClassesInScoutBundles((IScoutBundle)this.getScoutBundle()), TypeComparators.getTypeNameComparator());
        for (IType consumerType : wsConsumerTypes) {
            new WebServiceConsumerNodePage((IPage)this, consumerType);
        }
    }

    public XmlResource getBuildJaxWsResource() {
        return ResourceFactory.getBuildJaxWsResource(this.m_bundle);
    }

    private class P_BuildJaxWsResourceListener
    implements IResourceListener {
        private P_BuildJaxWsResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            JaxWsSdkUtility.markStructureDirtyAndFixSelection((IPage)WebServiceConsumerTablePage.this);
        }
    }

    private class P_TypeHierarchyChangedListener
    implements ITypeHierarchyChangedListener {
        private P_TypeHierarchyChangedListener() {
        }

        public void hierarchyInvalidated() {
            WebServiceConsumerTablePage.this.markStructureDirty();
        }
    }
}

