/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AbstractPropertyPresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FolderPresenter
extends AbstractPropertyPresenter<IFolder> {
    private Composite m_composite;
    private Text m_textField;
    private Button m_button;
    private boolean m_showBrowseButton;
    private String m_messageFolderDialog;
    private String m_titleFolderDialog;

    public FolderPresenter(Composite parent, PropertyViewFormToolkit toolkit) {
        this(parent, toolkit, 120, true);
    }

    public FolderPresenter(Composite parent, PropertyViewFormToolkit toolkit, int labelWidth, boolean initialize) {
        super(parent, toolkit, labelWidth, false);
        this.setLabel(Texts.get("Folder"));
        this.setMessageFolderDialog(Texts.get("ChooseFolder"));
        this.setTitleFolderDialog(Texts.get("ChooseFolder"));
        this.setUseLinkAsLabel(true);
        this.setShowBrowseButton(true);
        if (initialize) {
            this.callInitializer();
        }
    }

    @Override
    protected final Control createContent(Composite parent) {
        this.m_composite = this.getToolkit().createComposite(parent, 0);
        this.m_textField = this.getToolkit().createText(this.m_composite, "", 2308);
        this.m_textField.setEditable(false);
        this.m_textField.setBackground(JaxWsSdkUtility.getColorLightGray());
        this.m_button = new Button(this.m_composite, 0x800008);
        this.m_button.setText(this.getConfiguredBrowseButtonLabel());
        this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFolder folder = FolderPresenter.this.execBrowseAction();
                if (folder != null) {
                    FolderPresenter.this.setInputInternal(folder);
                    FolderPresenter.this.setValueFromUI(folder);
                }
            }
        });
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.marginBottom = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = false;
        this.m_composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.m_textField.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.widthHint = 50;
        gd.horizontalIndent = 5;
        gd.exclude = !this.isShowBrowseButton();
        this.m_button.setLayoutData((Object)gd);
        return this.m_composite;
    }

    @Override
    protected void setInputInternal(IFolder input) {
        if (input != null) {
            this.m_textField.setText(input.getProjectRelativePath().toString());
            this.m_textField.setToolTipText(input.getProjectRelativePath().toString());
        } else {
            this.m_textField.setText("");
            this.m_textField.setToolTipText(null);
        }
        this.setUseLinkAsLabel(input != null && input.exists());
    }

    @Override
    protected void execLinkAction() throws CoreException {
        IFolder folder = (IFolder)this.getValue();
        if (folder != null && folder.exists()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IPackagesViewPart viewPart = (IPackagesViewPart)page.showView("org.eclipse.jdt.ui.PackageExplorer");
            viewPart.selectAndReveal((Object)folder);
        } else {
            JaxWsSdk.logInfo("Could not find folder");
        }
    }

    protected IFolder execBrowseAction() {
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        FolderSelectionDialog dialog = new FolderSelectionDialog(ScoutSdkUi.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(this.getTitleFolderDialog());
        dialog.setMessage(this.getMessageFolderDialog());
        dialog.addFilter(this.createFilter());
        dialog.setHelpAvailable(false);
        dialog.setAllowMultiple(false);
        dialog.setInput((Object)this.m_bundle.getProject());
        dialog.setInitialSelection(this.getValue());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    public boolean isShowBrowseButton() {
        return this.m_showBrowseButton;
    }

    public void setShowBrowseButton(boolean showBrowseButton) {
        if (this.m_showBrowseButton == showBrowseButton) {
            return;
        }
        this.m_showBrowseButton = showBrowseButton;
        this.m_showBrowseButton = showBrowseButton;
        if (this.isControlCreated()) {
            ((GridData)this.m_button.getLayoutData()).exclude = !showBrowseButton;
            this.m_composite.layout();
        }
    }

    protected ViewerFilter createFilter() {
        return new FolderFilter(this.m_bundle);
    }

    protected String getConfiguredBrowseButtonLabel() {
        return Texts.get("Browse");
    }

    public String getMessageFolderDialog() {
        return this.m_messageFolderDialog;
    }

    public void setMessageFolderDialog(String messageFolderDialog) {
        this.m_messageFolderDialog = messageFolderDialog;
    }

    public String getTitleFolderDialog() {
        return this.m_titleFolderDialog;
    }

    public void setTitleFolderDialog(String titleFolderDialog) {
        this.m_titleFolderDialog = titleFolderDialog;
    }

    public static class FolderFilter
    extends ViewerFilter {
        private IScoutBundle m_bundle;
        private Set<IPath> m_unsupportedFolders = new HashSet<IPath>();

        public FolderFilter(IScoutBundle bundle) {
            this.m_bundle = bundle;
            try {
                IClasspathEntry[] iClasspathEntryArray = this.m_bundle.getJavaProject().getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                    IPath outputLocation = classpathEntry.getOutputLocation();
                    if (outputLocation != null) {
                        this.m_unsupportedFolders.add(this.toProjectRelativePath(outputLocation));
                    }
                    if (classpathEntry.getEntryKind() == 3) {
                        this.m_unsupportedFolders.add(this.toProjectRelativePath(classpathEntry.getPath()));
                    }
                    ++n2;
                }
                IPath defaultOutputLocation = this.m_bundle.getJavaProject().getOutputLocation();
                if (defaultOutputLocation != null) {
                    this.m_unsupportedFolders.add(this.toProjectRelativePath(defaultOutputLocation));
                }
            }
            catch (Exception e) {
                JaxWsSdk.logError(e);
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof IFolder)) {
                return false;
            }
            IFolder folder = (IFolder)element;
            if (folder.getName().startsWith(".")) {
                return false;
            }
            return !this.m_unsupportedFolders.contains(folder.getProjectRelativePath());
        }

        private IPath toProjectRelativePath(IPath path) {
            IFolder folder = this.m_bundle.getProject().getFolder(path);
            if (folder != null && folder.exists()) {
                return folder.getProjectRelativePath();
            }
            folder = this.m_bundle.getProject().getWorkspace().getRoot().getFolder(path);
            if (folder != null && folder.exists()) {
                return folder.getProjectRelativePath();
            }
            return path;
        }
    }
}

