/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.HandlerChainFilterWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HandlerChainFilterWizard
extends AbstractWorkspaceWizard {
    private HandlerChainFilterWizardPage m_wizardPage;
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private Element m_xmlHandlerChain;
    private HandlerChainFilterWizardPage.FilterTypeEnum m_filterTypeEnum;
    private String m_namespacePrefix;
    private String m_namespace;
    private String m_pattern;

    public HandlerChainFilterWizard() {
        this.setWindowTitle(Texts.get("HandlerChainFilter"));
    }

    public void init(IScoutBundle bundle, SunJaxWsBean sunJaxWsBean, Element xmlHandlerChain) {
        this.m_bundle = bundle;
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.m_xmlHandlerChain = xmlHandlerChain;
        Element xmlFilterProtocol = JaxWsSdkUtility.getChildElement(this.m_xmlHandlerChain.getChildNodes(), this.toQualifiedName("protocol-bindings"));
        Element xmlFilterService = JaxWsSdkUtility.getChildElement(this.m_xmlHandlerChain.getChildNodes(), this.toQualifiedName("service-name-pattern"));
        Element xmlFilterPort = JaxWsSdkUtility.getChildElement(this.m_xmlHandlerChain.getChildNodes(), this.toQualifiedName("port-name-pattern"));
        if (xmlFilterProtocol != null) {
            this.m_filterTypeEnum = HandlerChainFilterWizardPage.FilterTypeEnum.PROTOCOL_FILTER;
            this.m_pattern = xmlFilterProtocol.getTextContent();
        } else if (xmlFilterService != null || xmlFilterPort != null) {
            Element xmlFilter;
            if (xmlFilterService != null) {
                xmlFilter = xmlFilterService;
                this.m_filterTypeEnum = HandlerChainFilterWizardPage.FilterTypeEnum.SERVICE_FILTER;
            } else {
                xmlFilter = xmlFilterPort;
                this.m_filterTypeEnum = HandlerChainFilterWizardPage.FilterTypeEnum.PORT_FILTER;
            }
            this.m_pattern = xmlFilter.getTextContent();
        } else {
            this.m_filterTypeEnum = HandlerChainFilterWizardPage.FilterTypeEnum.NO_FILTER;
        }
    }

    public void addPages() {
        this.m_wizardPage = new HandlerChainFilterWizardPage(this.m_bundle);
        this.m_wizardPage.setFilterType(this.m_filterTypeEnum);
        this.m_wizardPage.setNamespacePrefix(this.m_namespacePrefix);
        this.m_wizardPage.setNamespace(this.m_namespace);
        this.m_wizardPage.setPattern(this.m_pattern);
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    protected boolean beforeFinish() throws CoreException {
        this.m_filterTypeEnum = this.m_wizardPage.getFilterType();
        this.m_namespacePrefix = this.m_wizardPage.getNamespacePrefix();
        this.m_namespace = this.m_wizardPage.getNamespace();
        this.m_pattern = this.m_wizardPage.getPattern();
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        JaxWsSdkUtility.removeAllChildElements(this.m_xmlHandlerChain, this.toQualifiedName("protocol-bindings"));
        JaxWsSdkUtility.removeAllChildElements(this.m_xmlHandlerChain, this.toQualifiedName("service-name-pattern"));
        JaxWsSdkUtility.removeAllChildElements(this.m_xmlHandlerChain, this.toQualifiedName("port-name-pattern"));
        Node firstChild = null;
        switch (this.m_filterTypeEnum) {
            case PROTOCOL_FILTER: {
                Element protocolFilter = this.m_xmlHandlerChain.getOwnerDocument().createElement(this.toQualifiedName("protocol-bindings"));
                firstChild = this.m_xmlHandlerChain.getFirstChild();
                if (firstChild == null) {
                    this.m_xmlHandlerChain.appendChild(protocolFilter);
                } else {
                    this.m_xmlHandlerChain.insertBefore(firstChild, protocolFilter);
                }
                protocolFilter.setTextContent(this.m_pattern);
                break;
            }
            case SERVICE_FILTER: {
                Element serviceFilter = this.m_xmlHandlerChain.getOwnerDocument().createElement(this.toQualifiedName("service-name-pattern"));
                firstChild = this.m_xmlHandlerChain.getFirstChild();
                if (firstChild == null) {
                    this.m_xmlHandlerChain.appendChild(serviceFilter);
                } else {
                    this.m_xmlHandlerChain.insertBefore(firstChild, serviceFilter);
                }
                serviceFilter.setTextContent(this.m_pattern);
                serviceFilter.setPrefix(this.m_namespacePrefix);
                break;
            }
            case PORT_FILTER: {
                Element portFilter = this.m_xmlHandlerChain.getOwnerDocument().createElement(this.toQualifiedName("port-name-pattern"));
                firstChild = this.m_xmlHandlerChain.getFirstChild();
                if (firstChild == null) {
                    this.m_xmlHandlerChain.appendChild(portFilter);
                } else {
                    this.m_xmlHandlerChain.insertBefore(firstChild, portFilter);
                }
                portFilter.setTextContent(this.m_pattern);
                portFilter.setPrefix(this.m_namespacePrefix);
            }
        }
        ResourceFactory.getSunJaxWsResource(this.m_bundle).storeXmlAsync(this.m_xmlHandlerChain.getOwnerDocument(), 512, this.m_sunJaxWsBean.getAlias());
        return true;
    }

    private String toQualifiedName(String name) {
        return this.m_sunJaxWsBean.toQualifiedName(name);
    }
}

