/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.util.Comparator;
import java.util.Locale;
import org.eclipse.scout.commons.StringUtility;

public class ArrayComparator
implements Comparator<Object[]> {
    private ColumnComparator[] m_comparators;

    public ArrayComparator(ColumnComparator ... comparators) {
        this.m_comparators = comparators;
    }

    public ArrayComparator(Locale locale, int ... sortCols) {
        this.m_comparators = new ColumnComparator[sortCols.length];
        int i = 0;
        while (i < sortCols.length) {
            this.m_comparators[i] = new ColumnComparator(sortCols[i], new DefaultObjectComparator(locale));
            ++i;
        }
    }

    @Override
    public int compare(Object[] a, Object[] b) {
        if (this.m_comparators == null || this.m_comparators.length == 0) {
            return 0;
        }
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int i = 0;
        while (i < this.m_comparators.length && this.m_comparators[i].getColumnIndex() < a.length && this.m_comparators[i].getColumnIndex() < b.length) {
            Object o1 = a[this.m_comparators[i].getColumnIndex()];
            Object o2 = b[this.m_comparators[i].getColumnIndex()];
            int c = this.m_comparators[i].getComparator().compare(o1, o2);
            if (c != 0) {
                return c;
            }
            ++i;
        }
        if (a.length < b.length) {
            return -1;
        }
        if (a.length > b.length) {
            return 1;
        }
        return 0;
    }

    public static class ColumnComparator {
        private int m_columnIndex;
        private Comparator<Object> m_comparator;

        public ColumnComparator(int columnIndex, Comparator<Object> comparator) {
            this.m_columnIndex = columnIndex;
            this.m_comparator = comparator;
        }

        public int getColumnIndex() {
            return this.m_columnIndex;
        }

        public Comparator<Object> getComparator() {
            return this.m_comparator;
        }
    }

    public static class DefaultObjectComparator
    implements Comparator<Object> {
        private Locale m_locale;

        public DefaultObjectComparator(Locale locale) {
            this.m_locale = locale;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int c = 0;
            c = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : (o1 instanceof String && o2 instanceof String ? StringUtility.compareIgnoreCase(this.m_locale, (String)o1, (String)o2) : (o1 instanceof Comparable && o2 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : StringUtility.compareIgnoreCase(this.m_locale, o1.toString(), o2.toString())))));
            return c;
        }
    }
}

