/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.Collator;
import org.eclipse.scout.commons.ReflectionUtility;

public class CollationRulesPatch {
    private CollationRulesPatch() {
    }

    public static void patchDefaultCollationRules() {
        try {
            CollationRulesPatch.changeDefaultCollationRules();
            CollationRulesPatch.clearCollatorCache();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void revertPatchDefaultCollationRules() {
        try {
            CollationRulesPatch.revertDefaultCollationRules();
            CollationRulesPatch.clearCollatorCache();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void changeDefaultCollationRules() throws Exception {
        Field defaultRulesField = CollationRulesPatch.getDefaultCollationRulesField();
        CollationRulesPatch.replaceDefaultCollationRules(defaultRulesField, "<'_'", "<' ','-'<'_'");
        ReflectionUtility.setFinalFlagOnField(defaultRulesField);
    }

    private static void revertDefaultCollationRules() throws Exception {
        Field defaultRulesField = CollationRulesPatch.getDefaultCollationRulesField();
        CollationRulesPatch.replaceDefaultCollationRules(defaultRulesField, "<' ','-'<'_'", "<'_'");
        ReflectionUtility.setFinalFlagOnField(defaultRulesField);
    }

    private static Field getDefaultCollationRulesField() throws Exception {
        Class<?> collationRulesClass = Class.forName("java.text.CollationRules");
        Field defaultRulesField = collationRulesClass.getDeclaredField("DEFAULTRULES");
        ReflectionUtility.removeFinalFlagOnField(defaultRulesField);
        return defaultRulesField;
    }

    private static void replaceDefaultCollationRules(Field defaultRulesField, String oldRule, String newRule) throws Exception {
        defaultRulesField.setAccessible(true);
        String defaultRules = (String)defaultRulesField.get(null);
        if (defaultRules.contains(newRule) && !defaultRules.contains(oldRule)) {
            return;
        }
        String newRules = defaultRules.replaceAll(oldRule, newRule);
        defaultRulesField.set(null, newRules);
        defaultRulesField.setAccessible(false);
    }

    private static void clearCollatorCache() throws Exception {
        Field cacheField = CollationRulesPatch.getAccessibleCollatorCacheField();
        CollationRulesPatch.clearCollatorCacheField(cacheField);
        cacheField.setAccessible(false);
    }

    private static Field getAccessibleCollatorCacheField() throws Exception {
        Field cacheField = Collator.class.getDeclaredField("cache");
        cacheField.setAccessible(true);
        return cacheField;
    }

    private static void clearCollatorCacheField(Field cacheField) throws Exception {
        Object softCache = cacheField.get(null);
        if (softCache != null) {
            Class<?> softcacheClass = cacheField.getType();
            Method cacheClearMethod = softcacheClass.getDeclaredMethod("clear", new Class[0]);
            cacheClearMethod.invoke(softCache, new Object[0]);
        }
    }
}

