/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.scout.commons.LocaleThreadLocal;

public final class FormattingUtility {
    private FormattingUtility() {
    }

    public static String fixedRecord(String s, int length) {
        StringBuffer b = new StringBuffer(s != null ? s : "");
        while (b.length() < length) {
            b.append(" ");
        }
        return b.toString();
    }

    public static String formatObject(Object o) {
        Locale loc = LocaleThreadLocal.get();
        String ret = null;
        if (o instanceof String) {
            ret = (String)o;
        } else if (o instanceof Date) {
            ret = DateFormat.getDateInstance(2, loc).format(o);
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)o);
            int hour = cal.get(10);
            int minute = cal.get(12);
            int second = cal.get(13);
            if (hour != 0 || minute != 0 || second != 0) {
                ret = DateFormat.getDateTimeInstance(3, 3, loc).format(o);
            }
        } else if (o instanceof Float || o instanceof Double || o instanceof BigDecimal) {
            NumberFormat f = DecimalFormat.getInstance(loc);
            f.setMinimumFractionDigits(2);
            f.setMaximumFractionDigits(2);
            ret = f.format(o);
        } else if (o instanceof Number) {
            ret = NumberFormat.getNumberInstance(loc).format(o);
        } else if (o instanceof Boolean) {
            ret = (Boolean)o != false ? "X" : "";
        }
        return ret == null ? "" : ret;
    }
}

