/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger;

import java.io.File;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.internal.Activator;
import org.eclipse.scout.commons.logger.IScoutLogManager;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.internal.eclipse.EclipseScoutLogManager;
import org.eclipse.scout.commons.logger.internal.java.JavaScoutLogManager;

public final class ScoutLogManager {
    public static final IScoutLogManager instance = ScoutLogManager.createScoutLogManager();

    static {
        instance.initialize();
    }

    private ScoutLogManager() {
    }

    private static IScoutLogManager createScoutLogManager() {
        String strategy = ScoutLogManager.getProperty("org.eclipse.scout.log");
        if (strategy != null) {
            if ("eclipse".equalsIgnoreCase(strategy)) {
                return new EclipseScoutLogManager();
            }
            if ("java".equalsIgnoreCase(strategy)) {
                return new JavaScoutLogManager();
            }
        }
        if (Activator.getDefault() != null) {
            try {
                Class clazz = Activator.getDefault().getBundle().loadClass("org.eclipse.scout.commons.logger.CustomLogManager");
                if (clazz != null && IScoutLogManager.class.isAssignableFrom(clazz)) {
                    return (IScoutLogManager)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new JavaScoutLogManager();
    }

    public static String getProperty(String property) {
        if (Activator.getDefault() != null) {
            return Activator.getDefault().getBundle().getBundleContext().getProperty(property);
        }
        return System.getProperty(property, null);
    }

    public static void setGlobalLogLevel(Integer level) throws UnsupportedOperationException {
        instance.setGlobalLogLevel(level);
    }

    public static Integer getGlobalLogLevel() throws UnsupportedOperationException {
        return instance.getGlobalLogLevel();
    }

    public static boolean startRecording() throws ProcessingException, UnsupportedOperationException {
        return instance.startRecording();
    }

    public static File stopRecording() throws UnsupportedOperationException {
        return instance.stopRecording();
    }

    public static IScoutLogger getLogger(Class clazz) {
        return instance.getLogger(clazz);
    }

    public static IScoutLogger getLogger(String name) {
        return instance.getLogger(name);
    }
}

