/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.parsers.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

final class SqlParserToken {
    private static IScoutLogger logger = ScoutLogManager.getLogger(SqlParserToken.class);

    public static abstract class AbstractToken
    implements IToken {
        private String m_text;
        private List<IToken> m_children;
        private List<Comment> m_comments;

        @Override
        public String getText() {
            return this.m_text;
        }

        @Override
        public void setText(String text) {
            this.m_text = text;
        }

        @Override
        public void addChild(IToken child) {
            if (this.m_children == null) {
                this.m_children = new ArrayList<IToken>();
            }
            this.m_children.add(child);
        }

        @Override
        public void addChildren(List<IToken> children) {
            if (this.m_children == null) {
                this.m_children = new ArrayList<IToken>();
            }
            this.m_children.addAll(children);
        }

        @Override
        public List<IToken> getChildren() {
            return CollectionUtility.arrayList(this.m_children);
        }

        @Override
        public void addComment(Comment c) {
            if (this.m_comments == null) {
                this.m_comments = new ArrayList<Comment>();
            }
            this.m_comments.add(c);
        }

        @Override
        public List<Comment> getComments() {
            return CollectionUtility.arrayList(this.m_comments);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.getText() != null) {
                buf.append(this.getText());
            }
            for (IToken t : this.getChildren()) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(t.toString());
            }
            return buf.toString();
        }
    }

    public static class AndExpr
    extends AbstractToken {
    }

    public static class AndOp
    extends AbstractToken {
    }

    public static class Atom
    extends AbstractToken {
    }

    public static class BracketExpr
    extends AbstractToken {
    }

    public static class CloseBracketToken
    extends AbstractToken {
        private int m_level;

        public int getLevel() {
            return this.m_level;
        }

        public void setLevel(int level) {
            this.m_level = level;
        }
    }

    public static class Comment
    extends AbstractToken {
        public Comment() {
        }

        public Comment(String text) {
            this.setText(text);
        }
    }

    public static class FunExpr
    extends AbstractToken {
    }

    public static interface IToken {
        public String getText();

        public void setText(String var1);

        public void addChild(IToken var1);

        public void addChildren(List<IToken> var1);

        public List<IToken> getChildren();

        public void addComment(Comment var1);

        public List<Comment> getComments();
    }

    public static class ListExpr
    extends AbstractToken {
    }

    public static class ListSeparator
    extends AbstractToken {
    }

    public static class MathExpr
    extends AbstractToken {
    }

    public static class MathOp
    extends AbstractToken {
    }

    public static class MinusExpr
    extends AbstractToken {
    }

    public static class Name
    extends AbstractToken {
    }

    public static class OpenBracketToken
    extends AbstractToken {
        private int m_level;

        public int getLevel() {
            return this.m_level;
        }

        public void setLevel(int level) {
            this.m_level = level;
        }
    }

    public static class OrExpr
    extends AbstractToken {
    }

    public static class OrOp
    extends AbstractToken {
    }

    public static class OuterJoinToken
    extends AbstractToken {
    }

    public static class Part
    extends AbstractToken {
    }

    public static class PartToken
    extends AbstractToken {
    }

    public static class Raw
    extends AbstractToken {
        public Raw(String text) {
            this.setText(text);
        }
    }

    public static class SingleStatement
    extends AbstractToken {
    }

    public static class Statement
    extends AbstractToken {
    }

    public static class Text
    extends AbstractToken {
    }

    public static class UnaryPrefix
    extends AbstractToken {
    }

    public static class UnaryPrefixExpr
    extends AbstractToken {
    }

    public static class UnionToken
    extends AbstractToken {
    }

    public static class Unparsed
    extends AbstractToken {
    }
}

