/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.model.workspace.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.ITranslationResource;

public class NlsResourceProvider {
    private List<Language> m_languagesOrdered;
    private final Map<Language, ITranslationResource> m_resourceMap = new HashMap<Language, ITranslationResource>();

    public NlsResourceProvider() {
        this.m_languagesOrdered = CollectionUtility.emptyArrayList();
    }

    public void addResource(ITranslationResource r) {
        Language language = r.getLanguage();
        if (this.m_resourceMap.containsKey(language)) {
            NlsCore.logWarning("language already exists!");
        } else {
            this.m_resourceMap.put(language, r);
            this.m_languagesOrdered = NlsResourceProvider.getOrderedLanguages(this.m_resourceMap.keySet());
        }
    }

    private static List<Language> getOrderedLanguages(Set<Language> languages) {
        TreeMap<CompositeObject, Language> orderedLanguages = new TreeMap<CompositeObject, Language>();
        for (Language l : languages) {
            int index = 3;
            if (l.equals(Language.LANGUAGE_KEY)) {
                index = 1;
            } else if (l.equals(Language.LANGUAGE_DEFAULT)) {
                index = 2;
            }
            orderedLanguages.put(new CompositeObject(new Object[]{index, l.getDispalyName()}), l);
        }
        return CollectionUtility.arrayList(orderedLanguages.values());
    }

    public void remove(ITranslationResource r) {
        if (!this.m_resourceMap.containsValue(r)) {
            NlsCore.logWarning("trying to remove a non existing resource!");
        } else {
            this.m_resourceMap.remove(r.getLanguage());
            this.m_languagesOrdered = NlsResourceProvider.getOrderedLanguages(this.m_resourceMap.keySet());
        }
    }

    public List<ITranslationResource> getSortedResources() {
        ArrayList<ITranslationResource> resources = new ArrayList<ITranslationResource>(this.m_languagesOrdered.size());
        for (Language lang : this.m_languagesOrdered) {
            resources.add(this.m_resourceMap.get(lang));
        }
        return resources;
    }

    public List<ITranslationResource> getResources() {
        return CollectionUtility.arrayList(this.m_resourceMap.values());
    }

    public ITranslationResource getResource(Language language) {
        return this.m_resourceMap.get(language);
    }

    public boolean containsResource(Language language) {
        return this.m_resourceMap.containsKey(language);
    }

    public List<Language> getAllLanguages() {
        return CollectionUtility.arrayList(this.m_languagesOrdered);
    }
}

