/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.ui;

import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.nls.sdk.internal.ui.formatter.IInputValidator;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;

public final class InputValidator {
    private static final Pattern REGEX_NLS_KEY_NAME = Pattern.compile("\\b[A-Za-z0-9][a-zA-Z0-9_.\\-]{0,200}\\b");

    private InputValidator() {
    }

    public static IInputValidator getNlsKeyValidator(INlsProject project) {
        return InputValidator.getNlsKeyValidator(project, new String[0]);
    }

    public static IInputValidator getNlsKeyValidator(INlsProject project, String[] exceptions) {
        return new P_KeyEntryValidator(project, exceptions);
    }

    public static IInputValidator getDefaultTranslationValidator() {
        return new IInputValidator(){

            @Override
            public IStatus isValid(String value) {
                if (value.length() > 0) {
                    return Status.OK_STATUS;
                }
                return new Status(4, "org.eclipse.scout.nls.sdk", 32, "The default translation must be set.", null);
            }
        };
    }

    private static final class P_KeyEntryValidator
    implements IInputValidator {
        private final HashSet<String> m_exceptions;
        private final INlsProject m_project;

        public P_KeyEntryValidator(INlsProject project, String[] exceptions) {
            this.m_exceptions = new HashSet(exceptions.length);
            String[] stringArray = exceptions;
            int n = exceptions.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.m_exceptions.add(s);
                ++n2;
            }
            this.m_project = project;
        }

        private INlsEntry getEntry(String key) {
            return this.getEntry(this.m_project, key);
        }

        private INlsEntry getEntry(INlsProject project, String key) {
            if (project == null) {
                return null;
            }
            INlsEntry e = project.getEntry(key);
            if (e != null) {
                return e;
            }
            return this.getEntry(project.getParent(), key);
        }

        @Override
        public IStatus isValid(String value) {
            INlsEntry e;
            if (!this.m_exceptions.contains(value) && (e = this.getEntry(value)) != null) {
                if (e.getType() == 1) {
                    return new Status(4, "org.eclipse.scout.nls.sdk", 32, "A key '" + value + "' already exists!", null);
                }
                return new Status(2, "org.eclipse.scout.nls.sdk", 32, "The key '" + value + "' overrides an inherited entry.", null);
            }
            if (!REGEX_NLS_KEY_NAME.matcher(value).matches()) {
                return new Status(4, "org.eclipse.scout.nls.sdk", 32, "The key name is not valid.", null);
            }
            return Status.OK_STATUS;
        }
    }
}

