/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columnfilter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class ComparableColumnFilter<T extends Comparable<T>>
implements ITableColumnFilter<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private IColumn<T> m_column;
    private Set<T> m_selectedValues;
    private T m_minimumValue;
    private T m_maximumValue;

    public ComparableColumnFilter(IColumn<T> column) {
        this.m_column = column;
    }

    @Override
    public IColumn<T> getColumn() {
        return this.m_column;
    }

    @Override
    public void setColumn(IColumn column) {
        this.m_column = column;
    }

    @Override
    public Set<T> getSelectedValues() {
        return this.m_selectedValues;
    }

    @Override
    public void setSelectedValues(Set<T> set) {
        this.m_selectedValues = set;
    }

    public T getMinimumValue() {
        return this.m_minimumValue;
    }

    public void setMinimumValue(T minimumValue) {
        this.m_minimumValue = minimumValue;
    }

    public T getMaximumValue() {
        return this.m_maximumValue;
    }

    public void setMaximumValue(T maximumValue) {
        this.m_maximumValue = maximumValue;
    }

    @Override
    public List<LookupRow<T>> createHistogram() {
        TreeMap<Comparable, LookupRow> hist = new TreeMap<Comparable, LookupRow>();
        HashMap<Comparable, Integer> countMap = new HashMap<Comparable, Integer>();
        for (ITableRow iTableRow : this.m_column.getTable().getRows()) {
            Integer count;
            Comparable key = (Comparable)this.m_column.getValue(iTableRow);
            String text = this.m_column.getDisplayText(iTableRow);
            if (key != null && !hist.containsKey(key)) {
                FontSpec font = iTableRow.isFilterAccepted() ? null : FontSpec.parse((String)"italic");
                hist.put(key, new LookupRow((Object)key, text, null, null, null, null, font));
            }
            countMap.put(key, (count = (Integer)countMap.get(key)) != null ? count + 1 : 1);
        }
        for (Map.Entry entry : hist.entrySet()) {
            Integer count = (Integer)countMap.get(entry.getKey());
            if (count == null || count <= 1) continue;
            ((LookupRow)entry.getValue()).setText(String.valueOf(((LookupRow)entry.getValue()).getText()) + " (" + count + ")");
        }
        ArrayList<LookupRow<T>> arrayList = new ArrayList<LookupRow<T>>();
        arrayList.addAll(hist.values());
        Integer nullCount = (Integer)countMap.get(null);
        arrayList.add(new LookupRow(null, "(" + ScoutTexts.get((String)"ColumnFilterNullText", (String[])new String[0]) + ")" + (nullCount != null && nullCount > 1 ? " (" + nullCount + ")" : "")));
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return (this.m_selectedValues == null || this.m_selectedValues.isEmpty()) && this.m_minimumValue == null && this.m_maximumValue == null;
    }

    @Override
    public boolean accept(ITableRow row) {
        Comparable value = (Comparable)this.m_column.getValue(row);
        if (this.m_minimumValue != null) {
            if (value == null) {
                return false;
            }
            if (value.compareTo(this.m_minimumValue) < 0) {
                return false;
            }
        }
        if (this.m_maximumValue != null) {
            if (value == null) {
                return false;
            }
            if (value.compareTo(this.m_maximumValue) > 0) {
                return false;
            }
        }
        return this.m_selectedValues == null || this.m_selectedValues.contains(value);
    }
}

