/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.tablefield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.xmlparser.SimpleXmlElement;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.tablefield.ITableFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.tablefield.TableFieldChains;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.INumberColumn;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValidateContentDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.ValidateFormFieldDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ValidateTableFieldDescriptor;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldData;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="76887bde-6815-4f7d-9cbd-60409b49488d")
@FormData(value=AbstractTableFieldBeanData.class, sdkCommand=FormData.SdkCommand.USE, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.CREATE)
public abstract class AbstractTableField<T extends ITable>
extends AbstractFormField
implements ITableField<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTableField.class);
    private T m_table;
    private boolean m_tableExternallyManaged;
    private P_ManagedTableListener m_managedTableListener;
    private P_TableStatusListener m_tableStatusListener;

    public AbstractTableField() {
        this(true);
    }

    public AbstractTableField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigOperation
    @Order(value=190.0)
    protected void execReloadTableData() throws ProcessingException {
    }

    @Override
    public String createDefaultTableStatus() {
        StringBuilder statusText = new StringBuilder();
        T table = this.getTable();
        if (table != null) {
            int nTotal = table.getFilteredRowCount();
            if (nTotal == 1) {
                statusText.append(ScoutTexts.get((String)"OneRow", (String[])new String[0]));
            } else {
                statusText.append(ScoutTexts.get((String)"XRows", (String[])new String[]{NumberUtility.format((Number)nTotal)}));
            }
            int fTotal = table.getRowCount() - nTotal;
            if (fTotal == 1) {
                statusText.append(", " + ScoutTexts.get((String)"OneFiltered", (String[])new String[0]));
            } else if (fTotal > 1) {
                statusText.append(", " + ScoutTexts.get((String)"XFiltered", (String[])new String[]{NumberUtility.format((Number)fTotal)}));
            }
            int nSel = table.getSelectedRowCount();
            if (nSel == 1) {
                statusText.append(", " + ScoutTexts.get((String)"OneSelected", (String[])new String[0]));
            } else if (nSel > 1) {
                statusText.append(", " + ScoutTexts.get((String)"XSelected", (String[])new String[]{NumberUtility.format((Number)nSel)}));
                for (IColumn<?> c : table.getColumnSet().getVisibleColumns()) {
                    if (!(c instanceof INumberColumn)) continue;
                    DecimalFormat fmt = null;
                    BigDecimal sum = null;
                    fmt = ((INumberColumn)c).getFormat();
                    INumberColumn numberColumn = (INumberColumn)c;
                    sum = NumberUtility.sum(numberColumn.getSelectedValues());
                    if (fmt == null || sum == null) continue;
                    statusText.append(", " + c.getHeaderCell().getText() + ": " + fmt.format(sum));
                }
            }
        }
        if (statusText.length() == 0) {
            return null;
        }
        return statusText.toString();
    }

    @ConfigOperation
    @Order(value=195.0)
    protected void execUpdateTableStatus() {
        if (!this.isTableStatusVisible()) {
            return;
        }
        this.setTableStatus(this.createDefaultTableStatus());
    }

    @ConfigOperation
    @Order(value=200.0)
    protected void execSave(List<? extends ITableRow> insertedRows, List<? extends ITableRow> updatedRows, List<? extends ITableRow> deletedRows) {
    }

    @ConfigOperation
    @Order(value=210.0)
    protected void execSaveDeletedRow(ITableRow row) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=220.0)
    protected void execSaveInsertedRow(ITableRow row) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execSaveUpdatedRow(ITableRow row) throws ProcessingException {
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) throws ProcessingException {
        this.reloadTableData();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredTableStatusVisible() {
        return false;
    }

    protected Class<? extends ITable> getConfiguredTable() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List f = ConfigurationUtility.filterClasses((Class[])dca, ITable.class);
        if (f.size() == 1) {
            return (Class)CollectionUtility.firstElement((List)f);
        }
        for (Class c : f) {
            if (c.getDeclaringClass() == AbstractTableField.class) continue;
            return c;
        }
        return null;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setTableStatusVisible(this.getConfiguredTableStatusVisible());
        this.setTableInternal(this.createTable());
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AbstractTableField.this.m_table != null) {
                    AbstractTableField.this.m_table.setEnabled(AbstractTableField.this.isEnabled());
                }
            }
        });
    }

    protected T createTable() {
        List contributedFields = this.m_contributionHolder.getContributionsByClass(ITable.class);
        ITable result = (ITable)CollectionUtility.firstElement((List)contributedFields);
        if (result != null) {
            return (T)result;
        }
        Class<ITable> configuredTable = this.getConfiguredTable();
        if (configuredTable != null) {
            try {
                return (T)((ITable)ConfigurationUtility.newInnerInstance((Object)this, configuredTable));
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + configuredTable.getName() + "'.", (Throwable)e));
            }
        }
        return null;
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            this.m_table.initTable();
        }
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            this.m_table.disposeTable();
        }
    }

    @Override
    public final T getTable() {
        return this.m_table;
    }

    @Override
    public void setTable(T newTable, boolean externallyManaged) {
        this.m_tableExternallyManaged = externallyManaged;
        this.setTableInternal(newTable);
    }

    private void setTableInternal(T table) {
        boolean changed;
        if (this.m_table == table) {
            return;
        }
        if (this.m_table instanceof AbstractTable) {
            ((AbstractTable)this.m_table).setContainerInternal(null);
        }
        if (this.m_table != null) {
            if (!this.m_tableExternallyManaged && this.m_managedTableListener != null) {
                this.m_table.removeTableListener(this.m_managedTableListener);
                this.m_managedTableListener = null;
            }
            if (this.m_tableStatusListener != null) {
                this.m_table.removeTableListener(this.m_tableStatusListener);
                this.m_tableStatusListener = null;
            }
        }
        this.m_table = table;
        if (this.m_table instanceof AbstractTable) {
            ((AbstractTable)this.m_table).setContainerInternal(this);
        }
        if (this.m_table != null) {
            if (!this.m_tableExternallyManaged) {
                this.m_managedTableListener = new P_ManagedTableListener();
                this.m_table.addTableListener(this.m_managedTableListener);
            }
            this.m_tableStatusListener = new P_TableStatusListener();
            this.m_table.addTableListener(this.m_tableStatusListener);
            this.updateTableStatus();
            this.m_table.setEnabled(this.isEnabled());
        }
        if (changed = this.propertySupport.setProperty("table", this.m_table)) {
            if (this.getForm() != null) {
                this.getForm().structureChanged(this);
            }
            this.updateKeyStrokes();
        }
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) throws ProcessingException {
        if (this.m_table != null) {
            if (target instanceof AbstractTableFieldData) {
                AbstractTableFieldData tableFieldData = (AbstractTableFieldData)target;
                this.m_table.extractTableData(tableFieldData);
            } else if (target instanceof AbstractTableFieldBeanData) {
                AbstractTableFieldBeanData tableBeanData = (AbstractTableFieldBeanData)target;
                this.m_table.exportToTableBeanData(tableBeanData);
                target.setValueSet(true);
            }
        }
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) throws ProcessingException {
        if (source.isValueSet() && this.m_table != null) {
            try {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(false);
                }
                if (source instanceof AbstractTableFieldData) {
                    AbstractTableFieldData tableFieldData = (AbstractTableFieldData)source;
                    this.m_table.updateTable(tableFieldData);
                } else if (source instanceof AbstractTableFieldBeanData) {
                    AbstractTableFieldBeanData tableBeanData = (AbstractTableFieldBeanData)source;
                    this.m_table.importFromTableBeanData(tableBeanData);
                }
                if (this.m_table.isCheckable() && this.m_table.getCheckableColumn() != null) {
                    for (ITableRow row : this.m_table.getRows()) {
                        row.setChecked(BooleanUtility.nvl((Boolean)((Boolean)this.m_table.getCheckableColumn().getValue(row))));
                    }
                }
            }
            finally {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(true);
                }
            }
        }
    }

    @Override
    public void loadXML(SimpleXmlElement x) throws ProcessingException {
        super.loadXML(x);
        if (this.m_table != null) {
            int[] selectedRowIndices = null;
            try {
                selectedRowIndices = (int[])x.getObjectAttribute("selectedRowIndices", null);
            }
            catch (Exception e) {
                LOG.warn("reading attribute 'selectedRowIndices'", (Throwable)e);
            }
            Object[][] dataMatrix = null;
            try {
                dataMatrix = (Object[][])x.getObjectAttribute("rows", null);
            }
            catch (Exception e) {
                LOG.warn("reading attribute 'rows'", (Throwable)e);
            }
            this.m_table.discardAllRows();
            if (dataMatrix != null && dataMatrix.length > 0) {
                this.m_table.addRowsByMatrix(dataMatrix);
            }
            if (selectedRowIndices != null && selectedRowIndices.length > 0) {
                this.m_table.selectRows(this.m_table.getRows(selectedRowIndices));
            }
        }
    }

    @Override
    public void storeXML(SimpleXmlElement x) throws ProcessingException {
        super.storeXML(x);
        if (this.m_table != null) {
            List<ITableRow> selectedRows = this.m_table.getSelectedRows();
            int[] selectedRowIndices = new int[selectedRows.size()];
            int i = 0;
            for (ITableRow selrow : selectedRows) {
                selectedRowIndices[i] = selrow.getRowIndex();
                ++i;
            }
            try {
                x.setObjectAttribute("selectedRowIndices", (Object)selectedRowIndices);
            }
            catch (Exception e) {
                LOG.warn("writing attribute 'selectedRowIndices'", (Throwable)e);
            }
            Object[][] dataMatrix = this.m_table.getTableData();
            int r = 0;
            while (r < dataMatrix.length) {
                int c = 0;
                while (c < dataMatrix[r].length) {
                    Object o = dataMatrix[r][c];
                    if (o != null && !(o instanceof Serializable)) {
                        LOG.warn("ignoring not serializable value at row=" + r + ", col=" + c + ": " + o + "[" + o.getClass() + "]");
                        dataMatrix[r][c] = null;
                    }
                    ++c;
                }
                ++r;
            }
            try {
                x.setObjectAttribute("rows", (Object)dataMatrix);
            }
            catch (Exception e) {
                LOG.warn("writing attribute 'rows'", (Throwable)e);
            }
        }
    }

    @Override
    protected boolean execIsSaveNeeded() throws ProcessingException {
        boolean b = false;
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            if (!b && this.m_table.getDeletedRowCount() > 0) {
                b = true;
            }
            if (!b && this.m_table.getInsertedRowCount() > 0) {
                b = true;
            }
            if (!b && this.m_table.getUpdatedRowCount() > 0) {
                b = true;
            }
        }
        return b;
    }

    @Override
    protected void execMarkSaved() throws ProcessingException {
        super.execMarkSaved();
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            try {
                this.m_table.setTableChanging(true);
                int i = 0;
                while (i < this.m_table.getRowCount()) {
                    ITableRow row = this.m_table.getRow(i);
                    if (!row.isStatusNonchanged()) {
                        row.setStatusNonchanged();
                    }
                    ++i;
                }
                this.m_table.discardAllDeletedRows();
            }
            finally {
                this.m_table.setTableChanging(false);
            }
        }
    }

    @Override
    protected boolean execIsEmpty() throws ProcessingException {
        if (this.m_table != null) {
            return this.m_table.getRowCount() == 0;
        }
        return true;
    }

    @Override
    public IValidateContentDescriptor validateContent() {
        IValidateContentDescriptor desc = super.validateContent();
        if (desc != null) {
            return desc;
        }
        T table = this.getTable();
        if (this.isMandatory() && (table == null || table.getRowCount() < 1)) {
            return new ValidateFormFieldDescriptor(this);
        }
        HashSet invisbleColumnsWithErrors = new HashSet();
        ValidateTableFieldDescriptor tableDesc = null;
        TreeSet<String> columnNames = new TreeSet<String>();
        if (table != null) {
            for (ITableRow iTableRow : table.getRows()) {
                for (IColumn<?> col : table.getColumns()) {
                    if (!col.isCellEditable(iTableRow)) continue;
                    try {
                        ICell cell = iTableRow.getCell(col);
                        if (cell.getErrorStatus() == null) continue;
                        if (col.isDisplayable() && !col.isVisible()) {
                            invisbleColumnsWithErrors.add(col);
                        }
                        if (tableDesc == null) {
                            tableDesc = new ValidateTableFieldDescriptor(this, iTableRow, col);
                        }
                        columnNames.add(col.getHeaderCell().getText());
                    }
                    catch (Throwable t) {
                        LOG.error("validating " + this.getClass().getSimpleName() + " for row " + iTableRow.getRowIndex() + " for column " + col.getClass().getSimpleName(), t);
                    }
                }
            }
        }
        for (IColumn iColumn : invisbleColumnsWithErrors) {
            iColumn.setVisible(true);
        }
        if (tableDesc == null) {
            return null;
        }
        tableDesc.setDisplayText(String.valueOf(ScoutTexts.get((String)"TableName", (String[])new String[0])) + " " + this.getLabel() + ": " + CollectionUtility.format(columnNames));
        return tableDesc;
    }

    @Override
    public String getTableStatus() {
        IProcessingStatus status = this.getTableSelectionStatus();
        return status != null ? status.getMessage() : null;
    }

    @Override
    public void setTableStatus(String status) {
        this.setTableSelectionStatus((IProcessingStatus)(status != null ? new ProcessingStatus(status, 1) : null));
    }

    @Override
    public IProcessingStatus getTableSelectionStatus() {
        return (IProcessingStatus)this.propertySupport.getProperty("tableSelectionStatus");
    }

    @Override
    public void setTableSelectionStatus(IProcessingStatus status) {
        this.propertySupport.setProperty("tableSelectionStatus", (Object)status);
    }

    @Override
    public IProcessingStatus getTablePopulateStatus() {
        return (IProcessingStatus)this.propertySupport.getProperty("tablePopulateStatus");
    }

    @Override
    public void setTablePopulateStatus(IProcessingStatus status) {
        this.propertySupport.setProperty("tablePopulateStatus", (Object)status);
    }

    @Override
    public boolean isTableStatusVisible() {
        return this.propertySupport.getPropertyBool("tableStatusVisible");
    }

    @Override
    public void setTableStatusVisible(boolean b) {
        this.propertySupport.setPropertyBool("tableStatusVisible", b);
        if (b) {
            this.updateTableStatus();
        }
    }

    @Override
    public void updateTableStatus() {
        try {
            this.interceptUpdateTableStatus();
        }
        catch (Throwable t) {
            LOG.warn("Updating status of " + this.getClass().getName(), t);
        }
    }

    @Override
    public void doSave() throws ProcessingException {
        if (this.m_table != null && !this.m_tableExternallyManaged) {
            try {
                this.m_table.setTableChanging(true);
                this.interceptSave(this.m_table.getInsertedRows(), this.m_table.getUpdatedRows(), this.m_table.getDeletedRows());
                for (ITableRow deletedRow : this.m_table.getDeletedRows()) {
                    this.interceptSaveDeletedRow(deletedRow);
                }
                for (ITableRow insertedRow : this.m_table.getInsertedRows()) {
                    this.interceptSaveInsertedRow(insertedRow);
                    insertedRow.setStatusNonchanged();
                    this.m_table.updateRow(insertedRow);
                }
                for (ITableRow updatedRow : this.m_table.getUpdatedRows()) {
                    this.interceptSaveUpdatedRow(updatedRow);
                    updatedRow.setStatusNonchanged();
                    this.m_table.updateRow(updatedRow);
                }
            }
            finally {
                this.m_table.setTableChanging(false);
            }
        }
        this.markSaved();
    }

    @Override
    public void reloadTableData() throws ProcessingException {
        this.interceptReloadTableData();
    }

    @Override
    public List<IKeyStroke> getContributedKeyStrokes() {
        if (this.getTable() != null) {
            return MenuUtility.getKeyStrokesFromMenus(this.getTable().getMenus());
        }
        return CollectionUtility.emptyArrayList();
    }

    protected ITableFieldExtension<T, ? extends AbstractTableField<T>> createLocalExtension() {
        return new LocalTableFieldExtension(this);
    }

    protected final void interceptReloadTableData() throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TableFieldChains.TableFieldReloadTableDataChain chain = new TableFieldChains.TableFieldReloadTableDataChain(extensions);
        chain.execReloadTableData();
    }

    protected final void interceptUpdateTableStatus() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TableFieldChains.TableFieldUpdateTableStatusChain chain = new TableFieldChains.TableFieldUpdateTableStatusChain(extensions);
        chain.execUpdateTableStatus();
    }

    protected final void interceptSaveInsertedRow(ITableRow row) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TableFieldChains.TableFieldSaveInsertedRowChain chain = new TableFieldChains.TableFieldSaveInsertedRowChain(extensions);
        chain.execSaveInsertedRow(row);
    }

    protected final void interceptSaveUpdatedRow(ITableRow row) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TableFieldChains.TableFieldSaveUpdatedRowChain chain = new TableFieldChains.TableFieldSaveUpdatedRowChain(extensions);
        chain.execSaveUpdatedRow(row);
    }

    protected final void interceptSaveDeletedRow(ITableRow row) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TableFieldChains.TableFieldSaveDeletedRowChain chain = new TableFieldChains.TableFieldSaveDeletedRowChain(extensions);
        chain.execSaveDeletedRow(row);
    }

    protected final void interceptSave(List<? extends ITableRow> insertedRows, List<? extends ITableRow> updatedRows, List<? extends ITableRow> deletedRows) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TableFieldChains.TableFieldSaveChain chain = new TableFieldChains.TableFieldSaveChain(extensions);
        chain.execSave(insertedRows, updatedRows, deletedRows);
    }

    protected static class LocalTableFieldExtension<T extends ITable, OWNER extends AbstractTableField<T>>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements ITableFieldExtension<T, OWNER> {
        public LocalTableFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execReloadTableData(TableFieldChains.TableFieldReloadTableDataChain<? extends ITable> chain) throws ProcessingException {
            ((AbstractTableField)this.getOwner()).execReloadTableData();
        }

        @Override
        public void execUpdateTableStatus(TableFieldChains.TableFieldUpdateTableStatusChain<? extends ITable> chain) {
            ((AbstractTableField)this.getOwner()).execUpdateTableStatus();
        }

        @Override
        public void execSaveInsertedRow(TableFieldChains.TableFieldSaveInsertedRowChain<? extends ITable> chain, ITableRow row) throws ProcessingException {
            ((AbstractTableField)this.getOwner()).execSaveInsertedRow(row);
        }

        @Override
        public void execSaveUpdatedRow(TableFieldChains.TableFieldSaveUpdatedRowChain<? extends ITable> chain, ITableRow row) throws ProcessingException {
            ((AbstractTableField)this.getOwner()).execSaveUpdatedRow(row);
        }

        @Override
        public void execSaveDeletedRow(TableFieldChains.TableFieldSaveDeletedRowChain<? extends ITable> chain, ITableRow row) throws ProcessingException {
            ((AbstractTableField)this.getOwner()).execSaveDeletedRow(row);
        }

        @Override
        public void execSave(TableFieldChains.TableFieldSaveChain<? extends ITable> chain, List<? extends ITableRow> insertedRows, List<? extends ITableRow> updatedRows, List<? extends ITableRow> deletedRows) {
            ((AbstractTableField)this.getOwner()).execSave(insertedRows, updatedRows, deletedRows);
        }
    }

    private class P_ManagedTableListener
    extends TableAdapter {
        private P_ManagedTableListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            switch (e.getType()) {
                case 1: 
                case 100: 
                case 101: 
                case 102: 
                case 105: {
                    AbstractTableField.this.checkSaveNeeded();
                    AbstractTableField.this.checkEmpty();
                }
            }
        }
    }

    private class P_TableStatusListener
    extends TableAdapter {
        private P_TableStatusListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            switch (e.getType()) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 210: 
                case 820: {
                    AbstractTableField.this.updateTableStatus();
                }
            }
        }
    }
}

