/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.extension.ui.wizard.IWizardContainerFormExtension;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardContainerForm;

public abstract class AbstractWizardContainerForm
extends AbstractForm
implements IWizardContainerForm {
    private IWizard m_wizard;
    private P_WizardPropertyListener m_propertyChangeListener;

    public AbstractWizardContainerForm(IWizard w) throws ProcessingException {
        super(false);
        this.m_wizard = w;
        this.callInitializer();
    }

    @Override
    public IWizard getWizard() {
        return this.m_wizard;
    }

    @Override
    protected boolean getConfiguredMaximizeEnabled() {
        return true;
    }

    @Override
    protected void execInitForm() throws ProcessingException {
        if (this.m_wizard != null) {
            if (this.m_propertyChangeListener == null) {
                this.m_propertyChangeListener = new P_WizardPropertyListener();
            }
            this.m_wizard.addPropertyChangeListener(this.m_propertyChangeListener);
        }
        this.updateTitleFromWizard();
    }

    @Override
    protected void execDisposeForm() throws ProcessingException {
        if (this.m_wizard != null && this.m_propertyChangeListener != null) {
            this.m_wizard.removePropertyChangeListener(this.m_propertyChangeListener);
            this.m_propertyChangeListener = null;
        }
        super.doFinally();
    }

    @Override
    protected void execOnCloseRequest(boolean kill, HashSet<Integer> enabledButtonSystemTypes) throws ProcessingException {
        this.handleEscapeKey(kill);
    }

    protected void handleEscapeKey(boolean kill) throws ProcessingException {
        if (kill) {
            if (this.getWizardSuspendButton() != null && this.getWizardSuspendButton().isVisible() && this.getWizardSuspendButton().isEnabled()) {
                this.getWizard().doSuspend();
            } else if (this.getWizardCancelButton() != null && this.getWizardCancelButton().isVisible() && this.getWizardCancelButton().isEnabled()) {
                this.getWizard().doCancel();
            } else {
                this.getWizard().doCancel();
            }
        } else if (this.getWizardCancelButton() != null && this.getWizardCancelButton().isVisible() && this.getWizardCancelButton().isEnabled()) {
            this.getWizard().doCancel();
        } else if (this.getWizardSuspendButton() != null && this.getWizardSuspendButton().isVisible() && this.getWizardSuspendButton().isEnabled()) {
            this.getWizard().doSuspend();
        } else {
            this.getWizard().doCancel();
        }
    }

    protected void handleEnterKey() throws ProcessingException {
        if (this.getWizardNextStepButton() != null && this.getWizardNextStepButton().isVisible() && this.getWizardNextStepButton().isEnabled()) {
            this.getWizard().doNextStep();
        } else if (this.getWizardFinishButton() != null && this.getWizardFinishButton().isVisible() && this.getWizardFinishButton().isEnabled()) {
            this.getWizard().doFinish();
        }
    }

    protected void updateTitleFromWizard() {
        if (this.getWizard() != null) {
            String title = this.getWizard().getTitle();
            String subTitle = this.getWizard().getSubTitle();
            String s = "";
            if (title != null) {
                s = String.valueOf(s) + title;
            }
            if (subTitle != null) {
                s = String.valueOf(s) + " - " + subTitle;
            }
            this.setTitle(s);
        }
    }

    protected abstract IForm getInnerWizardForm();

    protected abstract void setInnerWizardForm(IForm var1);

    protected void handleWizardPropertyChanged(String propertyName, Object oldValue, Object newValue) {
        if ("wizardForm".equals(propertyName)) {
            this.setInnerWizardForm(this.getWizard().getWizardForm());
        } else if ("title".equals(propertyName)) {
            this.updateTitleFromWizard();
        } else if ("subTitle".equals(propertyName)) {
            this.updateTitleFromWizard();
        }
    }

    protected IWizardContainerFormExtension<? extends AbstractWizardContainerForm> createLocalExtension() {
        return new LocalWizardContainerFormExtension<AbstractWizardContainerForm>(this);
    }

    protected static class LocalWizardContainerFormExtension<OWNER extends AbstractWizardContainerForm>
    extends AbstractForm.LocalFormExtension<OWNER>
    implements IWizardContainerFormExtension<OWNER> {
        public LocalWizardContainerFormExtension(OWNER owner) {
            super(owner);
        }
    }

    private class P_WizardPropertyListener
    implements PropertyChangeListener {
        private P_WizardPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractWizardContainerForm.this.handleWizardPropertyChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }
}

