/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.extension.ui.wizard.IWizardStepExtension;
import org.eclipse.scout.rt.client.extension.ui.wizard.WizardStepChains;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractWizardStep<FORM extends IForm>
extends AbstractPropertyObserver
implements IWizardStep<FORM>,
IPropertyObserver,
IExtensibleObject {
    private IWizard m_wizard;
    private FORM m_form;
    private FormListener m_formListener;
    private int m_activationCounter;
    private boolean m_initialized;
    private final ObjectExtensions<AbstractWizardStep<FORM>, IWizardStepExtension<FORM, ? extends AbstractWizardStep<FORM>>> m_objectExtensions = new ObjectExtensions((Object)this);

    public AbstractWizardStep() {
        this(true);
    }

    public AbstractWizardStep(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.interceptInitConfig();
            this.m_initialized = true;
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=30.0)
    protected String getConfiguredTooltipText() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=35.0)
    protected String getConfiguredTitleHtml() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=38.0)
    protected String getConfiguredDescriptionHtml() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=40.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=60.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @Order(value=10.0)
    @ConfigOperation
    protected void execActivate(int stepKind) throws ProcessingException {
    }

    @Order(value=20.0)
    @ConfigOperation
    protected void execDeactivate(int stepKind) throws ProcessingException {
    }

    @Order(value=30.0)
    @ConfigOperation
    protected void execDispose() throws ProcessingException {
        FORM f = this.getForm();
        if (f != null) {
            f.doClose();
        }
    }

    @Order(value=40.0)
    @ConfigOperation
    protected void execFormStored(boolean activation) throws ProcessingException {
    }

    @Order(value=50.0)
    @ConfigOperation
    protected void execFormDiscarded(boolean activation) throws ProcessingException {
    }

    @Order(value=60.0)
    @ConfigOperation
    protected void execFormClosed(boolean activation) throws ProcessingException {
        if (!activation && this.getForm().isFormStored()) {
            this.getWizard().doNextStep();
        }
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        Class<?> cls = this.getClass();
        if (viewOrder == 9.876543212345678E16) {
            while (cls != null && IWizardStep.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractWizardStep.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        this.setTitle(this.getConfiguredTitle());
        this.setTooltipText(this.getConfiguredTooltipText());
        this.setTitleHtml(this.getConfiguredTitleHtml());
        this.setDescriptionHtml(this.getConfiguredDescriptionHtml());
        this.setIconId(this.getConfiguredIconId());
        this.setEnabled(this.getConfiguredEnabled());
        this.setOrder(this.calculateViewOrder());
    }

    protected IWizardStepExtension<FORM, ? extends AbstractWizardStep<FORM>> createLocalExtension() {
        return new LocalWizardStepExtension(this);
    }

    public final List<? extends IWizardStepExtension<FORM, ? extends AbstractWizardStep<FORM>>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    @Override
    public FORM getForm() {
        return this.m_form;
    }

    @Override
    public void setForm(FORM f) {
        if (this.m_form != null && this.m_formListener != null) {
            this.m_form.removeFormListener(this.m_formListener);
        }
        this.m_form = f;
        if (this.m_form != null) {
            if (this.m_formListener == null) {
                this.m_formListener = new FormListener(){

                    @Override
                    public void formChanged(FormEvent e) throws ProcessingException {
                        try {
                            switch (e.getType()) {
                                case 2020: {
                                    AbstractWizardStep.this.interceptFormStored(AbstractWizardStep.this.m_activationCounter > 0);
                                    break;
                                }
                                case 3000: {
                                    AbstractWizardStep.this.interceptFormDiscarded(AbstractWizardStep.this.m_activationCounter > 0);
                                    break;
                                }
                                case 3010: {
                                    AbstractWizardStep.this.interceptFormClosed(AbstractWizardStep.this.m_activationCounter > 0);
                                }
                            }
                        }
                        catch (ProcessingException pe) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(pe);
                        }
                        catch (Throwable t) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                        }
                        switch (e.getType()) {
                            case 3010: {
                                AbstractWizardStep.this.setForm(null);
                            }
                        }
                    }
                };
            }
            this.m_form.addFormListener(this.m_formListener);
        }
    }

    @Override
    public IWizard getWizard() {
        return this.m_wizard;
    }

    @Override
    public void setWizardInternal(IWizard w) {
        this.m_wizard = w;
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String s) {
        this.propertySupport.setPropertyString("iconId", s);
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public String getTooltipText() {
        return this.propertySupport.getPropertyString("tooltipText");
    }

    @Override
    public void setTooltipText(String s) {
        this.propertySupport.setPropertyString("tooltipText", s);
    }

    @Override
    public String getTitleHtml() {
        return this.propertySupport.getPropertyString("titleHtml");
    }

    @Override
    public void setTitleHtml(String s) {
        this.propertySupport.setPropertyString("titleHtml", s);
    }

    @Override
    public String getDescriptionHtml() {
        return this.propertySupport.getPropertyString("descriptionHtml");
    }

    @Override
    public void setDescriptionHtml(String s) {
        this.propertySupport.setPropertyString("descriptionHtml", s);
    }

    @Override
    public boolean isEnabled() {
        return this.propertySupport.getPropertyBool("enabled");
    }

    @Override
    public void setEnabled(boolean b) {
        this.propertySupport.setPropertyBool("enabled", b);
    }

    public double getOrder() {
        return this.propertySupport.getPropertyDouble("viewOrder");
    }

    public void setOrder(double order) {
        this.propertySupport.setPropertyDouble("viewOrder", order);
    }

    @Override
    public void activate(int stepKind) throws ProcessingException {
        try {
            ++this.m_activationCounter;
            this.interceptActivate(stepKind);
        }
        finally {
            --this.m_activationCounter;
        }
    }

    @Override
    public void deactivate(int stepKind) throws ProcessingException {
        try {
            ++this.m_activationCounter;
            this.interceptDeactivate(stepKind);
        }
        finally {
            --this.m_activationCounter;
        }
    }

    @Override
    public void dispose() throws ProcessingException {
        try {
            ++this.m_activationCounter;
            this.interceptDispose();
        }
        finally {
            --this.m_activationCounter;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getTitle() + "]";
    }

    public String classId() {
        return ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
    }

    protected final void interceptDeactivate(int stepKind) throws ProcessingException {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepDeactivateChain<FORM> chain = new WizardStepChains.WizardStepDeactivateChain<FORM>(extensions);
        chain.execDeactivate(stepKind);
    }

    protected final void interceptDispose() throws ProcessingException {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepDisposeChain<FORM> chain = new WizardStepChains.WizardStepDisposeChain<FORM>(extensions);
        chain.execDispose();
    }

    protected final void interceptFormClosed(boolean activation) throws ProcessingException {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepFormClosedChain<FORM> chain = new WizardStepChains.WizardStepFormClosedChain<FORM>(extensions);
        chain.execFormClosed(activation);
    }

    protected final void interceptActivate(int stepKind) throws ProcessingException {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepActivateChain<FORM> chain = new WizardStepChains.WizardStepActivateChain<FORM>(extensions);
        chain.execActivate(stepKind);
    }

    protected final void interceptFormDiscarded(boolean activation) throws ProcessingException {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepFormDiscardedChain<FORM> chain = new WizardStepChains.WizardStepFormDiscardedChain<FORM>(extensions);
        chain.execFormDiscarded(activation);
    }

    protected final void interceptFormStored(boolean activation) throws ProcessingException {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepFormStoredChain<FORM> chain = new WizardStepChains.WizardStepFormStoredChain<FORM>(extensions);
        chain.execFormStored(activation);
    }

    protected static class LocalWizardStepExtension<FORM extends IForm, OWNER extends AbstractWizardStep<FORM>>
    extends AbstractExtension<OWNER>
    implements IWizardStepExtension<FORM, OWNER> {
        public LocalWizardStepExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execDeactivate(WizardStepChains.WizardStepDeactivateChain<? extends IForm> chain, int stepKind) throws ProcessingException {
            ((AbstractWizardStep)this.getOwner()).execDeactivate(stepKind);
        }

        @Override
        public void execDispose(WizardStepChains.WizardStepDisposeChain<? extends IForm> chain) throws ProcessingException {
            ((AbstractWizardStep)this.getOwner()).execDispose();
        }

        @Override
        public void execFormClosed(WizardStepChains.WizardStepFormClosedChain<? extends IForm> chain, boolean activation) throws ProcessingException {
            ((AbstractWizardStep)this.getOwner()).execFormClosed(activation);
        }

        @Override
        public void execActivate(WizardStepChains.WizardStepActivateChain<? extends IForm> chain, int stepKind) throws ProcessingException {
            ((AbstractWizardStep)this.getOwner()).execActivate(stepKind);
        }

        @Override
        public void execFormDiscarded(WizardStepChains.WizardStepFormDiscardedChain<? extends IForm> chain, boolean activation) throws ProcessingException {
            ((AbstractWizardStep)this.getOwner()).execFormDiscarded(activation);
        }

        @Override
        public void execFormStored(WizardStepChains.WizardStepFormStoredChain<? extends IForm> chain, boolean activation) throws ProcessingException {
            ((AbstractWizardStep)this.getOwner()).execFormStored(activation);
        }
    }
}

