/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.ui.action.menu.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.extension.client.internal.AbstractExtensionManager;
import org.eclipse.scout.rt.extension.client.internal.IExtensionProcessor;
import org.eclipse.scout.rt.extension.client.ui.action.menu.CompositeMenuFilter;
import org.eclipse.scout.rt.extension.client.ui.action.menu.IMenuExtensionFilter;
import org.eclipse.scout.rt.extension.client.ui.action.menu.IMenuModifier;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.AbstractMenuExtension;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuAnchorFilter;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuContributionExtension;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuModificationExtension;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuRemoveExtension;
import org.osgi.framework.Bundle;

public class MenuExtensionManager
extends AbstractExtensionManager {
    public static final String EXTENSION_POINT_ID = "org.eclipse.scout.rt.extension.client.menus";
    public static final String MENU_CONTRIBUTION_ELEMENT = "menuContribution";
    public static final String MENU_REMOVAL_ELEMENT = "menuRemoval";
    public static final String MENU_MODIFICATION_ELEMENT = "menuModification";
    private static P_AnchorDescription NULL_ANCHOR_DESCRIPTION = new P_AnchorDescription(null, null);
    private final Map<Class<?>, List<MenuContributionExtension>> m_menuContributionExtensions = new HashMap();
    private final Map<Class<?>, List<MenuRemoveExtension>> m_menuRemoveExtensions = new HashMap();
    private final Map<Class<?>, List<MenuModificationExtension>> m_menuModificationExtensions = new HashMap();

    public MenuExtensionManager(IExtensionRegistry extensionRegistry) {
        super(extensionRegistry, EXTENSION_POINT_ID);
        this.initExtensionProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuContributionExtension> getMenuContributionExtensions(Class<?> anchorType) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getExtensions(this.m_menuContributionExtensions, anchorType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuRemoveExtension> getMenuRemoveExtensions(Class<?> anchorType) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getExtensions(this.m_menuRemoveExtensions, anchorType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuModificationExtension> getMenuModificationExtensions(Class<?> anchorType) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getExtensions(this.m_menuModificationExtensions, anchorType);
        }
    }

    private <T> List<T> getExtensions(Map<Class<?>, List<T>> extensions, Class<?> anchorType) {
        List<T> globalExtensions;
        this.ensureStarted();
        LinkedList<T> allMatchingExtensions = new LinkedList<T>();
        List<T> extensionsByAnchorType = extensions.get(anchorType);
        if (extensionsByAnchorType != null) {
            allMatchingExtensions.addAll(extensionsByAnchorType);
        }
        if ((globalExtensions = extensions.get(null)) != null) {
            allMatchingExtensions.addAll(globalExtensions);
        }
        return allMatchingExtensions;
    }

    private void initExtensionProcessors() {
        this.addExtensionProcessor(MENU_CONTRIBUTION_ELEMENT, new IExtensionProcessor<MenuContributionExtension>(){

            @Override
            public MenuContributionExtension processConfigurationElement(Bundle contributor, IConfigurationElement element) throws Exception {
                Class<IMenu> menuClass = MenuExtensionManager.loadClass(contributor, IMenu.class, element.getAttribute("class"));
                Double order = (Double)TypeCastUtility.castValue((Object)element.getAttribute("order"), Double.class);
                P_AnchorDescription anchorDescription = MenuExtensionManager.this.getAnchorDescription(contributor, element);
                CompositeMenuFilter filter = MenuExtensionManager.this.createFilter(element, anchorDescription);
                MenuContributionExtension menuContribution = new MenuContributionExtension(menuClass, filter, order);
                LinkedList<MenuContributionExtension> extensions = (LinkedList<MenuContributionExtension>)MenuExtensionManager.this.m_menuContributionExtensions.get(anchorDescription.getAnchorType());
                if (extensions == null) {
                    extensions = new LinkedList<MenuContributionExtension>();
                    MenuExtensionManager.this.m_menuContributionExtensions.put(anchorDescription.getAnchorType(), extensions);
                }
                extensions.add(menuContribution);
                return menuContribution;
            }
        });
        this.addExtensionProcessor(MENU_REMOVAL_ELEMENT, new IExtensionProcessor<MenuRemoveExtension>(){

            @Override
            public MenuRemoveExtension processConfigurationElement(Bundle contributor, IConfigurationElement element) throws Exception {
                Class<IMenu> menuClass = MenuExtensionManager.loadClass(contributor, IMenu.class, element.getAttribute("class"));
                P_AnchorDescription anchorDescription = MenuExtensionManager.this.getAnchorDescription(contributor, element);
                CompositeMenuFilter filter = MenuExtensionManager.this.createFilter(element, anchorDescription);
                MenuRemoveExtension menuRemoval = new MenuRemoveExtension(menuClass, filter);
                LinkedList<MenuRemoveExtension> extensions = (LinkedList<MenuRemoveExtension>)MenuExtensionManager.this.m_menuRemoveExtensions.get(anchorDescription.getAnchorType());
                if (extensions == null) {
                    extensions = new LinkedList<MenuRemoveExtension>();
                    MenuExtensionManager.this.m_menuRemoveExtensions.put(anchorDescription.getAnchorType(), extensions);
                }
                extensions.add(menuRemoval);
                return menuRemoval;
            }
        });
        this.addExtensionProcessor(MENU_MODIFICATION_ELEMENT, new IExtensionProcessor<MenuModificationExtension>(){

            @Override
            public MenuModificationExtension processConfigurationElement(Bundle contributor, IConfigurationElement element) throws Exception {
                Class<IMenu> menuClass = MenuExtensionManager.loadClass(contributor, IMenu.class, element.getAttribute("menu"));
                Class<IMenuModifier> modifierClass = MenuExtensionManager.loadClass(contributor, IMenuModifier.class, element.getAttribute("class"));
                P_AnchorDescription anchorDescription = MenuExtensionManager.this.getAnchorDescription(contributor, element);
                CompositeMenuFilter filter = MenuExtensionManager.this.createFilter(element, anchorDescription);
                MenuModificationExtension menuModification = new MenuModificationExtension(menuClass, filter, modifierClass);
                LinkedList<MenuModificationExtension> extensions = (LinkedList<MenuModificationExtension>)MenuExtensionManager.this.m_menuModificationExtensions.get(anchorDescription.getAnchorType());
                if (extensions == null) {
                    extensions = new LinkedList<MenuModificationExtension>();
                    MenuExtensionManager.this.m_menuModificationExtensions.put(anchorDescription.getAnchorType(), extensions);
                }
                extensions.add(menuModification);
                return menuModification;
            }
        });
    }

    private P_AnchorDescription getAnchorDescription(Bundle contributor, IConfigurationElement element) throws Exception {
        HashMap<String, Class<IDesktop>> anchorConfigurations = new HashMap<String, Class<IDesktop>>();
        anchorConfigurations.put("page", IPage.class);
        anchorConfigurations.put("formField", IFormField.class);
        anchorConfigurations.put("parentMenu", IMenu.class);
        anchorConfigurations.put("treeNode", ITreeNode.class);
        anchorConfigurations.put("desktop", IDesktop.class);
        Class<IPage> anchorType = null;
        Class anchorClass = null;
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            anchorType = (Class<IPage>)anchorConfigurations.get(child.getName());
            if (anchorType != null) {
                anchorClass = MenuExtensionManager.loadClass(contributor, anchorType, child.getAttribute("class"));
                if (anchorType == ITreeNode.class && IPage.class.isAssignableFrom(anchorClass)) {
                    anchorType = IPage.class;
                }
                return new P_AnchorDescription(anchorType, anchorClass);
            }
            ++n2;
        }
        return NULL_ANCHOR_DESCRIPTION;
    }

    private CompositeMenuFilter createFilter(IConfigurationElement element, P_AnchorDescription anchorDescription) {
        CompositeMenuFilter compositeFilter = new CompositeMenuFilter(new IMenuExtensionFilter[0]);
        if (anchorDescription != NULL_ANCHOR_DESCRIPTION) {
            compositeFilter.addFilter(new MenuAnchorFilter(anchorDescription.getAnchorClass()));
        }
        IConfigurationElement[] iConfigurationElementArray = element.getChildren("filter");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            try {
                IMenuExtensionFilter filter = (IMenuExtensionFilter)child.createExecutableExtension("class");
                compositeFilter.addFilter(filter);
            }
            catch (Exception e) {
                this.LOG.error("Exception while creating filter class [" + element.getAttribute("class") + "]", (Throwable)e);
            }
            ++n2;
        }
        if (!compositeFilter.isEmpty()) {
            return compositeFilter;
        }
        return null;
    }

    @Override
    protected void removeContributions(Set<Object> contributions) {
        for (List<MenuContributionExtension> list : this.m_menuContributionExtensions.values()) {
            list.removeAll(contributions);
        }
        for (List<AbstractMenuExtension> list : this.m_menuRemoveExtensions.values()) {
            list.removeAll(contributions);
        }
        for (List<AbstractMenuExtension> list : this.m_menuModificationExtensions.values()) {
            list.removeAll(contributions);
        }
    }

    private static class P_AnchorDescription {
        private final Class<?> m_anchorType;
        private final Class<?> m_anchorClass;

        public P_AnchorDescription(Class<?> anchorType, Class<?> anchorClass) {
            this.m_anchorType = anchorType;
            this.m_anchorClass = anchorClass;
        }

        public Class<?> getAnchorType() {
            return this.m_anchorType;
        }

        public Class<?> getAnchorClass() {
            return this.m_anchorClass;
        }
    }
}

