/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleClassDescriptor;
import org.eclipse.scout.commons.runtime.BundleBrowser;
import org.eclipse.scout.rt.shared.Activator;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeCache;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeStore;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeService;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.servicetunnel.RemoteServiceAccessDenied;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.Bundle;

public class SharedCodeService
extends AbstractService
implements ICodeService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SharedCodeService.class);
    private static final Long DEFAULT_PARTITION_ID = 0L;
    private final CodeTypeStore m_codeTypeStore = new CodeTypeStore();
    private final Object m_codeTypeClassDescriptorMapLock = new Object();
    private final HashMap<String, Set<BundleClassDescriptor>> m_codeTypeClassDescriptorMap = new HashMap();

    @Override
    public <T extends ICodeType<?, ?>> T getCodeType(Class<T> type) {
        return this.getCodeTypeCache().getCodeType(type);
    }

    @Override
    public <T extends ICodeType<?, ?>> T getCodeType(Long partitionId, Class<T> type) {
        return this.getCodeTypeCache(partitionId).getCodeType(type);
    }

    @Override
    public <T> ICodeType<T, ?> findCodeTypeById(T id) {
        if (id == null) {
            return null;
        }
        ICodeType<T, ?> ct = this.getCodeTypeCache().findCodeTypeById(id);
        if (ct != null) {
            return ct;
        }
        this.getAllCodeTypes("");
        return this.getCodeTypeCache().findCodeTypeById(id);
    }

    @Override
    public <T> ICodeType<T, ?> findCodeTypeById(Long partitionId, T id) {
        if (id == null) {
            return null;
        }
        ICodeType<T, ?> ct = this.getCodeTypeCache(partitionId).findCodeTypeById(id);
        if (ct != null) {
            return ct;
        }
        this.getAllCodeTypes("");
        return this.getCodeTypeCache(partitionId).findCodeTypeById(id);
    }

    @Override
    public List<ICodeType<?, ?>> getCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        return this.getCodeTypeCache().getCodeTypes(types);
    }

    @Override
    public List<ICodeType<?, ?>> getCodeTypes(Long partitionId, List<Class<? extends ICodeType<?, ?>>> types) {
        return this.getCodeTypeCache(partitionId).getCodeTypes(types);
    }

    @Override
    public <CODE_ID_TYPE, CODE extends ICode<CODE_ID_TYPE>> CODE getCode(Class<CODE> type) {
        return this.getCodeTypeCache().getCode(type);
    }

    @Override
    public <CODE_ID_TYPE, CODE extends ICode<CODE_ID_TYPE>> CODE getCode(Long partitionId, Class<CODE> type) {
        return this.getCodeTypeCache(partitionId).getCode(type);
    }

    @Override
    public <T extends ICodeType<?, ?>> T reloadCodeType(Class<T> type) throws ProcessingException {
        if (type == null) {
            return null;
        }
        ArrayList codetypeList = new ArrayList();
        codetypeList.add(type);
        this.m_codeTypeStore.unloadCodeTypeCache(codetypeList);
        this.notifyReloadCodeTypes(codetypeList);
        return this.getCodeTypeCache().reloadCodeType(type);
    }

    @Override
    public List<ICodeType<?, ?>> reloadCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) throws ProcessingException {
        if (types == null) {
            return null;
        }
        this.m_codeTypeStore.unloadCodeTypeCache(types);
        this.notifyReloadCodeTypes(types);
        return this.getCodeTypeCache().reloadCodeTypes(types);
    }

    protected void notifyReloadCodeTypes(List<Class<? extends ICodeType<?, ?>>> codetypeList) throws ProcessingException {
    }

    protected List<ICodeType<?, ?>> reloadCodeTypesNoFire(List<Class<? extends ICodeType<?, ?>>> types) throws ProcessingException {
        if (types == null) {
            return null;
        }
        this.m_codeTypeStore.unloadCodeTypeCacheNoFire(types);
        return this.reloadCodeTypes(types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BundleClassDescriptor> getAllCodeTypeClasses(String classPrefix) {
        if (classPrefix == null) {
            return CollectionUtility.hashSet((Object[])new BundleClassDescriptor[0]);
        }
        Object object = this.m_codeTypeClassDescriptorMapLock;
        synchronized (object) {
            Set<BundleClassDescriptor> a = this.m_codeTypeClassDescriptorMap.get(classPrefix);
            if (a != null) {
                return CollectionUtility.hashSet(a);
            }
            HashSet<BundleClassDescriptor> discoveredCodeTypes = new HashSet<BundleClassDescriptor>();
            Bundle[] bundleArray = Activator.getDefault().getBundle().getBundleContext().getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                block14: {
                    Bundle bundle = bundleArray[n2];
                    if ((bundle.getSymbolicName().startsWith(classPrefix) || classPrefix.startsWith(String.valueOf(bundle.getSymbolicName()) + ".")) && this.acceptBundle(bundle, classPrefix)) {
                        String[] classNames;
                        try {
                            BundleBrowser bundleBrowser = new BundleBrowser(bundle.getSymbolicName(), bundle.getSymbolicName());
                            classNames = bundleBrowser.getClasses(false, true);
                        }
                        catch (Exception e1) {
                            LOG.warn(null, (Throwable)e1);
                            break block14;
                        }
                        String[] stringArray = classNames;
                        int n3 = classNames.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String className = stringArray[n4];
                            if (this.acceptClassName(bundle, className)) {
                                try {
                                    Class c = null;
                                    c = bundle.loadClass(className);
                                    if (this.acceptClass(bundle, c)) {
                                        discoveredCodeTypes.add(new BundleClassDescriptor(bundle.getSymbolicName(), c.getName()));
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            this.m_codeTypeClassDescriptorMap.put(classPrefix, discoveredCodeTypes);
            return CollectionUtility.hashSet(discoveredCodeTypes);
        }
    }

    @Override
    public List<ICodeType<?, ?>> getAllCodeTypes(String classPrefix) {
        ArrayList list = new ArrayList();
        for (BundleClassDescriptor d : this.getAllCodeTypeClasses(classPrefix)) {
            try {
                list.add(Platform.getBundle((String)d.getBundleSymbolicName()).loadClass(d.getClassName()));
            }
            catch (Throwable t) {
                LOG.warn("Loading " + d.getClassName() + " of bundle " + d.getBundleSymbolicName(), t);
            }
        }
        return this.getCodeTypes(list);
    }

    @Override
    @RemoteServiceAccessDenied
    public List<ICodeType<?, ?>> getAllCodeTypes(String classPrefix, Long partitionId) {
        return this.getAllCodeTypes(classPrefix);
    }

    private CodeTypeCache getCodeTypeCache() {
        return this.getCodeTypeCache(this.provideCurrentPartitionId());
    }

    private CodeTypeCache getCodeTypeCache(Long partitionId) {
        return this.m_codeTypeStore.getCodeTypeCache(partitionId, LocaleThreadLocal.get());
    }

    protected boolean acceptBundle(Bundle bundle, String classPrefix) {
        return !Platform.isFragment((Bundle)bundle);
    }

    protected boolean acceptClassName(Bundle bundle, String className) {
        return className.indexOf("CodeType") >= 0;
    }

    protected boolean acceptClass(Bundle bundle, Class<?> c) {
        int flags;
        return ICodeType.class.isAssignableFrom(c) && !c.isInterface() && Modifier.isPublic(flags = c.getModifiers()) && !Modifier.isAbstract(flags) && !c.getSimpleName().startsWith("Abstract");
    }

    protected Long provideCurrentPartitionId() {
        return DEFAULT_PARTITION_ID;
    }
}

