/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen;

import java.util.Collection;
import org.eclipse.scout.rt.spec.client.config.entity.IDocEntityTableConfig;
import org.eclipse.scout.rt.spec.client.gen.DocGenUtility;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.out.internal.Section;
import org.eclipse.scout.rt.spec.client.out.mediawiki.MediawikiUtility;

public class TypeSpecGenerator {
    private final IDocEntityTableConfig<Class<?>> m_config;
    private String m_anchorId;
    private String m_title;
    private String m_introduction;

    public TypeSpecGenerator(IDocEntityTableConfig<Class<?>> config, String anchorId, String title, String introduction) {
        this.m_config = config;
        this.m_anchorId = anchorId;
        this.m_title = title;
        this.m_introduction = introduction;
    }

    public IDocSection getDocSection(Collection<Class<?>> types) {
        String anchor = MediawikiUtility.createAnchor(this.m_anchorId);
        String titleWithAnchor = String.valueOf(anchor) + MediawikiUtility.transformToWiki(this.m_title);
        if (types.isEmpty()) {
            return new Section(titleWithAnchor, new IDocSection[0]);
        }
        IDocSection typeSection = DocGenUtility.createDocSection(types, this.m_config, false);
        return new Section(titleWithAnchor, this.m_introduction, null, typeSection);
    }
}

