/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen.extract.form.field;

import java.util.List;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.spec.client.config.ConfigRegistry;
import org.eclipse.scout.rt.spec.client.filter.FilterUtility;
import org.eclipse.scout.rt.spec.client.filter.IDocFilter;
import org.eclipse.scout.rt.spec.client.gen.extract.AbstractNamedTextExtractor;
import org.eclipse.scout.rt.spec.client.gen.extract.IDocTextExtractor;
import org.eclipse.scout.rt.spec.client.gen.extract.form.field.FieldDetailTitleExtractor;
import org.eclipse.scout.rt.spec.client.out.mediawiki.MediawikiUtility;
import org.eclipse.scout.rt.spec.client.utility.SpecUtility;

public class FormFieldLabelExtractor
extends AbstractNamedTextExtractor<IFormField>
implements IDocTextExtractor<IFormField> {
    private boolean m_hierarchicLabels;
    private List<IDocFilter<IFormField>> m_docFilters;

    public FormFieldLabelExtractor(boolean hierarchicLabels, List<IDocFilter<IFormField>> docFilters) {
        super(TEXTS.get((String)"org.eclipse.scout.rt.spec.label"));
        this.m_hierarchicLabels = hierarchicLabels;
        this.m_docFilters = docFilters;
    }

    @Override
    public String getText(IFormField field) {
        StringBuilder label = new StringBuilder();
        label.append(MediawikiUtility.createAnchor(FormFieldLabelExtractor.createAnchorId(field)));
        if (this.isFieldWithDetailSection(field)) {
            label.append(MediawikiUtility.createLink(FieldDetailTitleExtractor.createAnchorId(field), this.getLabelOrSubstituteWhenEmpty(field)));
        } else {
            label.append(this.getLabelOrSubstituteWhenEmpty(field));
        }
        return this.decorateText(field, label.toString());
    }

    public static String createAnchorId(IFormField field) {
        StringBuilder sb = new StringBuilder();
        if (field.getForm() != null) {
            sb.append(SpecUtility.createAnchorId((ITypeWithClassId)field.getForm()));
        }
        sb.append("_field_");
        sb.append(field.classId());
        return sb.toString();
    }

    protected boolean isFieldWithDetailSection(IFormField field) {
        if (field instanceof ISmartField) {
            return true;
        }
        return field instanceof ITableField;
    }

    protected String decorateText(IFormField field, String displayName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIndentation(field));
        boolean emptyLabel = StringUtility.isNullOrEmpty((CharSequence)this.getLabel(field));
        if (emptyLabel) {
            sb.append("''");
        }
        sb.append(displayName);
        if (emptyLabel) {
            sb.append("''");
        }
        return sb.toString();
    }

    protected String getLabelOrSubstituteWhenEmpty(IFormField field) {
        StringBuilder sb = new StringBuilder();
        String label = this.getLabel(field);
        sb.append(StringUtility.substituteWhenEmpty((Object)label, (String)TEXTS.get((String)"org.eclipse.scout.rt.spec.withoutLabel")));
        return sb.toString().replaceAll("&", "");
    }

    protected String getLabel(IFormField field) {
        return MediawikiUtility.transformToWiki((String)field.getProperty("label"));
    }

    protected String getIndentation(IFormField field) {
        StringBuilder sb = new StringBuilder();
        if (this.m_hierarchicLabels) {
            int level = this.getLevel(field);
            sb.append(StringUtility.repeat((CharSequence)ConfigRegistry.getDocConfigInstance().getIndent(), (int)level));
        }
        return sb.toString();
    }

    protected int getLevel(IFormField field) {
        ICompositeField parentField = field.getParentField();
        int level = 0;
        while (parentField != null) {
            if (FilterUtility.isAccepted(parentField, this.m_docFilters)) {
                ++level;
            }
            parentField = parentField.getParentField();
        }
        return level;
    }
}

