/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ICustomColumn;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.basic.table.SortIconUtility;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingScoutTable;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingTableColumn;
import org.eclipse.scout.rt.ui.swing.ext.JTableEx;
import org.eclipse.scout.rt.ui.swing.icons.CompositeIcon;

public class SwingTableHeaderCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private TableCellRenderer m_internalRenderer;
    private SwingScoutTable m_swingScoutTable;
    private Icon m_sortUpIcon;
    private Icon m_sortDownIcon;
    private Icon m_filterActiveIcon;
    private Icon m_customColumnIcon;

    public SwingTableHeaderCellRenderer(TableCellRenderer internalRenderer, SwingScoutTable t) {
        this.m_internalRenderer = internalRenderer;
        this.m_swingScoutTable = t;
        this.m_sortUpIcon = Activator.getIcon("table_sort_asc");
        this.m_sortDownIcon = Activator.getIcon("table_sort_desc");
        this.m_filterActiveIcon = Activator.getIcon("table_column_filter_active");
        this.m_customColumnIcon = Activator.getIcon("table_custom_column");
    }

    @Override
    public Component getTableCellRendererComponent(JTable t, Object value, boolean selected, boolean hasFocus, int rowIndex, int colIndex) {
        JTableHeader header;
        JLabel label;
        Component comp = this.m_internalRenderer.getTableCellRendererComponent(t, value, selected, hasFocus, rowIndex, colIndex);
        JLabel jLabel = label = comp instanceof JLabel ? (JLabel)comp : null;
        if (label == null) {
            return comp;
        }
        JTableHeader jTableHeader = header = t != null ? t.getTableHeader() : null;
        if (header != null) {
            label.setForeground(header.getForeground());
            label.setBackground(header.getBackground());
            label.setFont(header.getFont());
        }
        label.setVerticalAlignment(1);
        JTableEx swingTable = this.m_swingScoutTable.getSwingTable();
        ITable scoutTable = (ITable)this.m_swingScoutTable.getScoutObject();
        IColumn scoutCol = ((SwingTableColumn)swingTable.getColumnModel().getColumn(colIndex)).getScoutColumn();
        if (scoutTable != null) {
            Color color;
            String text;
            IHeaderCell cell = scoutTable.getHeaderCell(scoutCol);
            int align = cell.getHorizontalAlignment();
            if (colIndex == 0 && !StringUtility.isNullOrEmpty((CharSequence)cell.getIconId())) {
                align = -1;
            }
            label.setVerticalAlignment(0);
            if (align > 0) {
                label.setHorizontalAlignment(4);
            } else if (align == 0) {
                label.setHorizontalAlignment(0);
            } else {
                label.setHorizontalAlignment(2);
            }
            label.setToolTipText(SwingUtility.createHtmlLabelText(cell.getTooltipText(), true));
            String string = text = value != null ? value.toString() : null;
            if (SwingUtility.isMultilineLabelText(text)) {
                text = SwingUtility.createHtmlLabelText(text, false);
            }
            label.setText(text);
            Icon sortIcon = null;
            if (cell.isSortActive() && cell.isSortExplicit()) {
                sortIcon = SortIconUtility.createSortIcon(scoutCol, scoutTable.getColumnSet().getSortColumns(), cell.isSortAscending());
            }
            Icon filterIcon = null;
            if (scoutCol.isColumnFilterActive()) {
                filterIcon = this.m_filterActiveIcon;
            }
            Icon customColumnIcon = null;
            if (scoutCol instanceof ICustomColumn) {
                customColumnIcon = this.m_customColumnIcon;
            }
            label.setIcon(null);
            if (sortIcon != null || filterIcon != null || customColumnIcon != null) {
                label.setIcon(new CompositeIcon(0, sortIcon, filterIcon, customColumnIcon));
            }
            if (cell.getBackgroundColor() != null) {
                color = ColorUtility.createColor(cell.getBackgroundColor());
                if (selected) {
                    color = color.darker();
                }
                label.setBackground(color);
            }
            if (cell.getForegroundColor() != null) {
                color = ColorUtility.createColor(cell.getForegroundColor());
                if (selected) {
                    color = color.brighter();
                }
                label.setForeground(color);
            }
            if (cell.getFont() != null) {
                Font oldf = label.getFont();
                Font newf = SwingUtility.createFont(cell.getFont(), oldf);
                if (oldf != null) {
                    label.setFont(new Font(oldf.getName(), newf.getStyle(), oldf.getSize()));
                }
            }
            label.setEnabled(scoutTable.isEnabled());
        }
        return label;
    }
}

