/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.concurrency;

import java.util.LinkedList;

public class LoopDetector {
    private long m_ttl;
    private int m_detectSize;
    private int m_releaseSize;
    private boolean m_armed;
    private LinkedList<Long> m_samples;

    public LoopDetector(long ttlMillis, int detectSize, int releaseSize) {
        this.m_ttl = ttlMillis;
        this.m_detectSize = detectSize;
        this.m_releaseSize = releaseSize;
        this.m_samples = new LinkedList();
    }

    protected long createTimestamp() {
        return System.currentTimeMillis();
    }

    public synchronized void addSample() {
        long ts = this.createTimestamp();
        while (this.m_samples.size() > 0 && this.m_samples.getFirst() + this.m_ttl < ts) {
            this.m_samples.removeFirst();
        }
        this.m_samples.add(ts);
        if (this.m_armed) {
            if (this.m_samples.size() <= this.m_releaseSize) {
                this.m_armed = false;
            }
        } else if (this.m_samples.size() > this.m_detectSize) {
            this.m_armed = true;
        }
    }

    public boolean isArmed() {
        return this.m_armed;
    }

    public int getSampleCount() {
        return this.m_samples.size();
    }
}

