/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.calendar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.eclipse.scout.rt.ui.swing.ext.calendar.DateChooser;

public class LargeCalendarLayout
implements LayoutManager2 {
    private DateChooser m_dateChooser;
    private Dimension m_minDim;
    private Dimension m_maxDim;
    private Dimension m_prefDim;

    public LargeCalendarLayout(DateChooser dateChooser) {
        this.m_dateChooser = dateChooser;
        this.m_prefDim = UIManager.getDimension("Calendar.large.preferredSize");
        if (this.m_prefDim == null) {
            this.m_prefDim = new Dimension(700, 500);
        }
        this.m_minDim = new Dimension(180, 140);
        this.m_maxDim = new Dimension(4000, 3000);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(this.m_minDim);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(this.m_maxDim);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(this.m_prefDim);
    }

    @Override
    public void layoutContainer(Container parent) {
        JPanel headerPanel = this.m_dateChooser.getHeaderPanel();
        JPanel daysPanel = this.m_dateChooser.getDaysPanel();
        JPanel controlPanel = this.m_dateChooser.getControlPanel();
        Dimension size = parent.getSize();
        Insets insets = parent.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int x = insets.left;
        int y = insets.top;
        int w = size.width - insets.left - insets.right;
        int h = size.height - insets.top - insets.bottom;
        if (headerPanel != null && headerPanel.isVisible()) {
            int headerHeight = headerPanel.getPreferredSize().height;
            headerPanel.setBounds(x, y, w, headerHeight);
            y += headerHeight;
        }
        if (daysPanel.isVisible()) {
            int dayH = daysPanel.getComponent((int)0).getPreferredSize().height;
            daysPanel.setBounds(x, y, w, dayH);
            y += dayH;
        }
        int controlHeight = 0;
        if (controlPanel != null && controlPanel.isVisible()) {
            controlHeight = controlPanel.getPreferredSize().height;
        }
        JPanel cellsPanel = this.m_dateChooser.getCellsPanel();
        int yNext = h - controlHeight;
        cellsPanel.setBounds(x, y, w, yNext - y);
        y = yNext;
        if (controlPanel != null && controlPanel.isVisible()) {
            controlPanel.setBounds(x, y, w, controlHeight);
            y += controlHeight;
        }
        this.m_dateChooser.updateTimelessSectionHeightHint();
    }
}

