/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.textfield;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.basic.document.BasicDocumentFilter;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutBasicFieldComposite;

public abstract class SwingScoutTextFieldComposite<T extends IStringField>
extends SwingScoutBasicFieldComposite<T> {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutTextFieldComposite.class);
    public static final String CLIENT_PROP_INITIAL_DISABLED_TEXT_COLOR = "scoutInitialDisabledForeground";
    private boolean m_upperCase;
    private boolean m_lowerCase;
    private MouseListener m_linkTrigger;
    private boolean m_decorationLink;
    private boolean m_multilineText;
    private DragGestureRecognizer m_dragSource;
    private DropTarget m_dropTarget;

    @Override
    protected void initializeSwing() {
    }

    @Override
    protected void setSwingField(JComponent swingField) {
        super.setSwingField(swingField);
        if (swingField instanceof JTextComponent) {
            JTextComponent textField = (JTextComponent)swingField;
            Document doc = textField.getDocument();
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).setDocumentFilter(new P_SwingDocumentFilter());
            }
            this.addInputListenersForBasicField(textField, doc);
        }
    }

    protected JTextComponent getSwingTextComponent() {
        return this.getSwingField();
    }

    @Override
    protected void attachScout() {
        IStringField f = (IStringField)this.getScoutObject();
        this.setDecorationLinkFromScout(f.isDecorationLink());
        this.setFormatFromScout(f.getFormat());
        this.setMaxLengthFromScout(f.getMaxLength());
        this.setMultilineTextFromScout(f.isMultilineText());
        super.attachScout();
        this.setSelectionFromScout();
        this.updateDragTransferTypesFromScout();
        this.updateDropTransferTypesFromScout();
    }

    @Override
    protected boolean isSelectAllOnFocusInScout() {
        return ((IStringField)this.getScoutObject()).isSelectAllOnFocus();
    }

    protected void setDecorationLinkFromScout(boolean b) {
        if (this.m_decorationLink != b) {
            this.m_decorationLink = b;
            JTextComponent swingField = this.getSwingTextComponent();
            if (b) {
                this.m_linkTrigger = new P_SwingLinkTrigger();
                swingField.addMouseListener(this.m_linkTrigger);
                swingField.setCursor(Cursor.getPredefinedCursor(12));
                this.setForegroundFromScout(((IStringField)this.getScoutObject()).getForegroundColor());
            } else {
                swingField.removeMouseListener(this.m_linkTrigger);
                this.m_linkTrigger = null;
                swingField.setCursor(null);
                this.setForegroundFromScout(((IStringField)this.getScoutObject()).getForegroundColor());
            }
        }
    }

    protected void setFormatFromScout(String s) {
        this.m_upperCase = false;
        this.m_lowerCase = false;
        if ("A".equals(s)) {
            this.m_upperCase = true;
        } else if ("a".equals(s)) {
            this.m_lowerCase = true;
        }
    }

    protected void setMultilineTextFromScout(boolean multilineText) {
        this.m_multilineText = multilineText;
    }

    protected void setMaxLengthFromScout(int n) {
        DocumentFilter filter;
        Document doc = this.getSwingTextComponent().getDocument();
        if (doc instanceof AbstractDocument && (filter = ((AbstractDocument)doc).getDocumentFilter()) instanceof BasicDocumentFilter) {
            ((BasicDocumentFilter)filter).setMaxLength(n);
        }
    }

    protected void setDoInsertFromScout(String s) {
        if (s != null && s.length() > 0) {
            JTextComponent swingField = this.getSwingTextComponent();
            int offset = swingField.getCaretPosition();
            int a = swingField.getSelectionStart();
            int b = swingField.getSelectionEnd();
            try {
                Document doc = swingField.getDocument();
                if (a >= 0 && b > a) {
                    doc.remove(a, b - a);
                    doc.insertString(a, s, null);
                } else if (offset >= 0) {
                    doc.insertString(offset, s, null);
                }
            }
            catch (Exception e) {
                LOG.warn("inserting \"" + s + "\" into " + ((IStringField)this.getScoutObject()).getLabel() + " at position " + offset, (Throwable)e);
            }
        }
    }

    @Override
    protected void cacheSwingClientProperties() {
        super.cacheSwingClientProperties();
        JTextComponent fld = this.getSwingTextComponent();
        if (fld != null && !this.existsClientProperty(fld, CLIENT_PROP_INITIAL_DISABLED_TEXT_COLOR)) {
            this.putClientProperty(fld, CLIENT_PROP_INITIAL_DISABLED_TEXT_COLOR, fld.getDisabledTextColor());
        }
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        if (scoutColor == null && this.m_decorationLink) {
            scoutColor = "445599";
        }
        super.setForegroundFromScout(scoutColor);
        JTextComponent fld = this.getSwingTextComponent();
        if (fld != null) {
            Color c = ColorUtility.createColor(scoutColor);
            c = c == null ? (Color)this.getClientProperty(fld, CLIENT_PROP_INITIAL_DISABLED_TEXT_COLOR) : this.getDisabledColor(c);
            fld.setDisabledTextColor(c);
        }
    }

    protected void setSelectionFromScout() {
        int startIndex = ((IStringField)this.getScoutObject()).getSelectionStart();
        int endIndex = ((IStringField)this.getScoutObject()).getSelectionEnd();
        JTextComponent swingField = this.getSwingTextComponent();
        Caret c = swingField.getCaret();
        int textLength = swingField.getText().length();
        if (startIndex < 0) {
            startIndex = c.getMark();
        }
        if (endIndex < 0) {
            endIndex = c.getDot();
        }
        startIndex = Math.min(Math.max(startIndex, -1), textLength);
        endIndex = Math.min(Math.max(endIndex, 0), textLength);
        if (c.getMark() != startIndex || c.getDot() != endIndex) {
            swingField.setCaretPosition(startIndex);
            swingField.moveCaretPosition(endIndex);
        }
    }

    @Override
    protected void setSelectionFromSwing() {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        Caret c = this.getSwingTextComponent().getCaret();
        int textLength = StringUtility.length((CharSequence)this.getSwingTextComponent().getText());
        final int startIndex = Math.min(Math.max(c.getMark(), -1), textLength);
        final int endIndex = Math.min(Math.max(c.getDot(), 0), textLength);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    SwingScoutTextFieldComposite.this.addIgnoredScoutEvent(PropertyChangeEvent.class, "selectionStart");
                    SwingScoutTextFieldComposite.this.addIgnoredScoutEvent(PropertyChangeEvent.class, "selectionEnd");
                    ((IStringField)SwingScoutTextFieldComposite.this.getScoutObject()).getUIFacade().setSelectionFromUI(startIndex, endIndex);
                }
                finally {
                    SwingScoutTextFieldComposite.this.removeIgnoredScoutEvent(PropertyChangeEvent.class, "selectionStart");
                    SwingScoutTextFieldComposite.this.removeIgnoredScoutEvent(PropertyChangeEvent.class, "selectionEnd");
                }
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected void updateDragTransferTypesFromScout() {
        int scoutDragTransfer = ((IStringField)this.getScoutObject()).getDragType();
        if (scoutDragTransfer != 0) {
            if (this.m_dragSource == null) {
                this.m_dragSource = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getSwingTextComponent(), 1, new P_DragGestureListener());
            }
            this.m_dragSource.setComponent(this.getSwingTextComponent());
        } else if (this.m_dragSource != null) {
            this.m_dragSource.setComponent(null);
        }
    }

    protected void updateDropTransferTypesFromScout() {
        if (((IStringField)this.getScoutObject()).getDropType() != 0) {
            if (this.m_dropTarget == null) {
                this.m_dropTarget = new DropTarget(this.getSwingTextComponent(), new P_DropTargetListener());
            }
            this.m_dropTarget.setComponent(this.getSwingTextComponent());
        } else if (this.m_dropTarget != null) {
            this.m_dropTarget.setComponent(null);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("decorationLink")) {
            this.setDecorationLinkFromScout((Boolean)newValue);
        } else if (name.equals("maxLength")) {
            this.setMaxLengthFromScout(((Number)newValue).intValue());
        } else if (name.equals("insertText")) {
            this.setDoInsertFromScout((String)newValue);
        } else if (name.equals("selectionStart")) {
            this.setSelectionFromScout();
        } else if (name.equals("selectionEnd")) {
            this.setSelectionFromScout();
        } else if (name.equals("multilineText")) {
            this.setMultilineTextFromScout((Boolean)newValue);
        }
    }

    protected void handleSwingLinkTrigger() {
        final String text = this.getSwingTextComponent().getText();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IStringField)SwingScoutTextFieldComposite.this.getScoutObject()).getUIFacade().fireLinkActionFromUI(text);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected Transferable handleSwingDragRequest() {
        final Holder result = new Holder(TransferObject.class, null);
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((IStringField)SwingScoutTextFieldComposite.this.getScoutObject()).getUIFacade().fireDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            try {
                this.getSwingEnvironment().invokeScoutLater(t, 5678L).join(5678L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        TransferObject scoutTransferable = (TransferObject)result.getValue();
        Transferable swingTransferable = null;
        swingTransferable = SwingUtility.createSwingTransferable(scoutTransferable);
        return swingTransferable;
    }

    protected void handleSwingDropAction(Transferable swingTransferable) {
        TransferObject scoutTransferable;
        if (this.getScoutObject() != null && swingTransferable != null && (scoutTransferable = SwingUtility.createScoutTransferable(swingTransferable)) != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IStringField)SwingScoutTextFieldComposite.this.getScoutObject()).getUIFacade().fireDropActionFromUi(scoutTransferable);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private class P_DragGestureListener
    implements DragGestureListener {
        private P_DragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Transferable to = SwingScoutTextFieldComposite.this.handleSwingDragRequest();
            if (to != null) {
                dge.startDrag(null, to);
            }
        }
    }

    private class P_DropTargetListener
    implements DropTargetListener {
        private P_DropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(1);
            SwingScoutTextFieldComposite.this.handleSwingDropAction(dtde.getTransferable());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    private class P_SwingDocumentFilter
    extends BasicDocumentFilter {
        private P_SwingDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String s, AttributeSet a) throws BadLocationException {
            s = this.ensureConfiguredTextFormat(s);
            super.insertString(fb, offset, s, a);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String s, AttributeSet a) throws BadLocationException {
            s = this.ensureConfiguredTextFormat(s);
            super.replace(fb, offset, length, s, a);
        }

        private String ensureConfiguredTextFormat(String s) {
            s = StringUtility.emptyIfNull((Object)s);
            if (SwingScoutTextFieldComposite.this.m_upperCase) {
                s = s.toUpperCase();
            } else if (SwingScoutTextFieldComposite.this.m_lowerCase) {
                s = s.toLowerCase();
            }
            if (!SwingScoutTextFieldComposite.this.m_multilineText) {
                s = StringUtility.trimNewLines((String)s);
                s = s.replaceAll("\r\n", " ").replaceAll("[\r\n]", " ");
            }
            return s;
        }
    }

    private class P_SwingLinkTrigger
    extends MouseAdapter {
        MouseClickedBugFix fix;

        private P_SwingLinkTrigger() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.fix = new MouseClickedBugFix(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.fix != null) {
                this.fix.mouseReleased(this, e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.fix.mouseClicked()) {
                return;
            }
            if (e.getClickCount() == 2) {
                SwingScoutTextFieldComposite.this.handleSwingLinkTrigger();
            }
        }
    }
}

