/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.smartfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldProposalForm;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.action.menu.MenuPositionCorrectionListener;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtScoutContextMenu;
import org.eclipse.scout.rt.ui.swt.action.menu.text.StyledTextAccess;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.smartfield.ISwtScoutSmartField;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.swt.keystroke.SwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.util.SwtLayoutUtility;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.window.popup.SwtScoutDropDownPopup;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutSmartField
extends SwtScoutValueFieldComposite<IContentAssistField<?, ?>>
implements ISwtScoutSmartField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutSmartField.class);
    private Button m_browseButton;
    private P_PendingProposalJob m_pendingProposalJob;
    private final Object m_pendingProposalJobLock;
    private SwtScoutDropDownPopup m_proposalPopup;
    private final Object m_popupLock = new Object();
    private TextFieldEditableSupport m_editableSupport;
    private SwtContextMenuMarkerComposite m_menuMarkerComposite;
    private SwtScoutContextMenu m_contextMenu;
    private PropertyChangeListener m_contextMenuVisibilityListener;

    public SwtScoutSmartField() {
        this.m_pendingProposalJobLock = new Object();
    }

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        this.m_menuMarkerComposite = new SwtContextMenuMarkerComposite(container, this.getEnvironment());
        this.getEnvironment().getFormToolkit().adapt((Composite)this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwtScoutSmartField.this.getSwtField().setFocus();
                SwtScoutSmartField.this.m_contextMenu.getSwtMenu().setVisible(true);
            }
        });
        final StyledText textField = this.getEnvironment().getFormToolkit().createStyledText((Composite)this.m_menuMarkerComposite, 4);
        textField.setAlignment(SwtUtility.getHorizontalAlignment(((IContentAssistField)this.getScoutObject()).getGridData().horizontalAlignment));
        textField.setMargins(2, 2, 2, 2);
        textField.setWrapIndent(textField.getIndent());
        this.m_browseButton = this.getEnvironment().getFormToolkit().createButton(container, "", 8);
        this.m_browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                textField.setFocus();
                SwtScoutSmartField.this.handleSwtBrowseAction();
            }
        });
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)textField);
        container.setTabList(new Control[]{this.m_menuMarkerComposite});
        this.getEnvironment().addKeyStroke((Widget)this.getSwtContainer(), new P_F2KeyStroke());
        P_UiFieldListener listener = new P_UiFieldListener();
        this.getSwtField().addListener(1, (Listener)listener);
        this.getSwtField().addListener(24, (Listener)listener);
        this.getSwtField().addListener(31, (Listener)listener);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_menuMarkerComposite.setLayoutData(LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
        this.m_browseButton.setLayoutData((Object)LogicalGridDataBuilder.createButton1());
    }

    protected void installContextMenu() {
        this.m_menuMarkerComposite.setMarkerVisible(((IContentAssistField)this.getScoutObject()).getContextMenu().isVisible());
        this.m_contextMenuVisibilityListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    final boolean markerVisible = ((IContentAssistField)SwtScoutSmartField.this.getScoutObject()).getContextMenu().isVisible();
                    SwtScoutSmartField.this.getEnvironment().invokeSwtLater(new Runnable(){

                        @Override
                        public void run() {
                            SwtScoutSmartField.this.m_menuMarkerComposite.setMarkerVisible(markerVisible);
                        }
                    });
                }
            }
        };
        ((IContentAssistField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(this.m_contextMenuVisibilityListener);
        this.m_contextMenu = new SwtScoutContextMenu(this.getSwtField().getShell(), (IContextMenu)((IContentAssistField)this.getScoutObject()).getContextMenu(), this.getEnvironment());
        this.getSwtBrowseButton().setMenu(this.m_contextMenu.getSwtMenu());
        SwtScoutContextMenu fieldMenu = new SwtScoutContextMenu(this.getSwtField().getShell(), (IContextMenu)((IContentAssistField)this.getScoutObject()).getContextMenu(), this.getEnvironment(), ((IContentAssistField)this.getScoutObject()).isAutoAddDefaultMenus() ? new StyledTextAccess(this.getSwtField()) : null, ((IContentAssistField)this.getScoutObject()).isAutoAddDefaultMenus() ? this.getSwtField() : null);
        this.getSwtField().setMenu(fieldMenu.getSwtMenu());
        this.getSwtField().addListener(35, (Listener)new MenuPositionCorrectionListener((Control)this.getSwtField()));
    }

    protected void uninstallContextMenu() {
        if (this.m_contextMenuVisibilityListener != null) {
            ((IContentAssistField)this.getScoutObject()).getContextMenu().removePropertyChangeListener(this.m_contextMenuVisibilityListener);
            this.m_contextMenuVisibilityListener = null;
        }
    }

    @Override
    public Button getSwtBrowseButton() {
        return this.m_browseButton;
    }

    public StyledText getSwtField() {
        return (StyledText)super.getSwtField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setIconIdFromScout(((IContentAssistField)this.getScoutObject()).getIconId());
        this.setProposalFormFromScout(((IContentAssistField)this.getScoutObject()).getProposalForm());
        this.installContextMenu();
    }

    @Override
    protected void detachScout() {
        this.hideProposalPopup();
        this.uninstallContextMenu();
        super.detachScout();
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        if (!CompareUtility.equals((Object)s, (Object)this.getSwtField().getText())) {
            if (s == null) {
                s = "";
            }
            StyledText swtField = this.getSwtField();
            swtField.setText(s);
            swtField.setCaretOffset(0);
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_browseButton.setEnabled(b);
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getSwtField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    protected void setIconIdFromScout(String s) {
        boolean iconVisible = s != null;
        boolean invalidateLayout = false;
        if (this.m_browseButton.isVisible() != iconVisible) {
            invalidateLayout = true;
        }
        this.m_browseButton.setVisible(iconVisible);
        this.m_browseButton.setImage(this.getEnvironment().getIcon(s));
        if (invalidateLayout && this.isConnectedToScout()) {
            SwtLayoutUtility.invalidateLayout((Control)this.m_browseButton);
        }
    }

    @Override
    protected void handleSwtFocusGained() {
        super.handleSwtFocusGained();
        if (this.m_proposalPopup == null) {
            this.scheduleSelectAll();
        }
        if (((IContentAssistField)this.getScoutObject()).getErrorStatus() != null && this.getSwtField().getEditable() && this.getSwtField().isVisible()) {
            this.requestProposalSupportFromSwt(((IContentAssistField)this.getScoutObject()).getDisplayText(), false);
        }
    }

    @Override
    protected void handleSwtFocusLost() {
        super.handleSwtFocusLost();
        if (!this.getSwtField().isDisposed()) {
            this.getSwtField().setSelection(0, 0);
        }
    }

    protected void scheduleSelectAll() {
        this.getEnvironment().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SwtScoutSmartField.this.getSwtField().isDisposed()) {
                    return;
                }
                SwtScoutSmartField.this.getSwtField().setSelection(0, SwtScoutSmartField.this.getSwtField().getText().length());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProposalFormFromScout(IContentAssistFieldProposalForm form) {
        Object object = this.m_pendingProposalJobLock;
        synchronized (object) {
            if (this.m_pendingProposalJob != null) {
                this.m_pendingProposalJob.cancel();
                this.m_pendingProposalJob = null;
            }
        }
        if (form != null) {
            this.showProposalPopup(form);
        } else {
            this.hideProposalPopup();
        }
    }

    protected void showProposalPopup(final IContentAssistFieldProposalForm form) {
        if (this.m_proposalPopup != null) {
            if (this.m_proposalPopup.isVisible()) {
                this.m_proposalPopup.closePart();
            }
            this.m_proposalPopup = null;
        }
        if (form != null) {
            if (this.getSwtField().isFocusControl()) {
                this.m_proposalPopup = new SwtScoutDropDownPopup(this.getEnvironment(), (Control)this.getSwtField(), false, 16);
                this.m_proposalPopup.setMaxHeightHint(((IContentAssistField)this.getScoutObject()).getProposalFormHeight());
                this.m_proposalPopup.addShellListener((ShellListener)new ShellAdapter(){

                    public void shellDeactivated(ShellEvent e) {
                        SwtScoutSmartField.this.hideProposalPopup();
                    }
                });
                this.m_proposalPopup.getShell().addShellListener((ShellListener)new ShellAdapter(){

                    public void shellClosed(ShellEvent e) {
                        e.doit = false;
                    }
                });
                this.m_proposalPopup.showForm((IForm)form);
                form.addFormListener(new FormListener(){

                    public void formChanged(FormEvent e) throws ProcessingException {
                        switch (e.getType()) {
                            case 5000: {
                                Runnable job = new Runnable(){

                                    @Override
                                    public void run() {
                                        if (SwtScoutSmartField.this.m_proposalPopup != null) {
                                            SwtScoutSmartField.this.m_proposalPopup.autoAdjustBounds();
                                        }
                                    }
                                };
                                SwtScoutSmartField.this.getEnvironment().invokeSwtLater(job);
                            }
                        }
                    }
                });
                this.getSwtField().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SwtScoutSmartField.this.m_proposalPopup != null) {
                            SwtScoutSmartField.this.m_proposalPopup.autoAdjustBounds();
                        }
                    }
                });
            } else {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            form.doClose();
                        }
                        catch (ProcessingException e) {
                            LOG.error("Failed to close smartfield form.", (Throwable)e);
                        }
                    }
                };
                this.getEnvironment().invokeScoutLater(t, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hideProposalPopup() {
        Object object = this.m_popupLock;
        synchronized (object) {
            if (this.m_proposalPopup != null && this.m_proposalPopup.isVisible()) {
                this.m_proposalPopup.closePart();
            }
            this.m_proposalPopup = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestProposalSupportFromSwt(String text, boolean selectCurrentValue) {
        Object object = this.m_pendingProposalJobLock;
        synchronized (object) {
            if (this.m_pendingProposalJob == null) {
                this.m_pendingProposalJob = new P_PendingProposalJob();
            } else {
                this.m_pendingProposalJob.cancel();
            }
            this.m_pendingProposalJob.update(text, selectCurrentValue);
            int delay = 200;
            if (this.m_proposalPopup == null) {
                delay = 0;
            }
            this.m_pendingProposalJob.schedule(delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptProposalFromSwt() {
        Object object = this.m_pendingProposalJobLock;
        synchronized (object) {
            if (this.m_pendingProposalJob != null) {
                this.m_pendingProposalJob.cancel();
                this.m_pendingProposalJob = null;
            }
        }
        final String text = this.getSwtField().getText();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IContentAssistField)SwtScoutSmartField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
            }
        };
        this.getEnvironment().invokeScoutLater(t, 0L);
    }

    @Override
    protected boolean filterKeyEvent(Event e) {
        if (this.m_proposalPopup != null && this.m_proposalPopup.isVisible()) {
            if (e.keyCode == 27) {
                this.hideProposalPopup();
                return false;
            }
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                this.acceptProposalFromSwt();
                return false;
            }
        }
        return super.filterKeyEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean handleSwtInputVerifier() {
        Object object = this.m_pendingProposalJobLock;
        synchronized (object) {
            if (this.m_pendingProposalJob != null) {
                this.m_pendingProposalJob.cancel();
                this.m_pendingProposalJob = null;
            }
        }
        final String text = this.getSwtField().getText();
        final Holder result = new Holder(Boolean.class, (Object)true);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IContentAssistField)SwtScoutSmartField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean processed = job.getState() == 0;
        this.getEnvironment().dispatchImmediateSwtJobs();
        return !processed || (Boolean)result.getValue() != false;
    }

    protected void handleSwtBrowseAction() {
        if (this.getSwtBrowseButton().isVisible() && this.getSwtBrowseButton().isEnabled()) {
            this.requestProposalSupportFromSwt("*", true);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("iconId")) {
            this.setIconIdFromScout((String)newValue);
        } else if (name.equals("proposalForm")) {
            this.setProposalFormFromScout((IContentAssistFieldProposalForm)newValue);
        }
    }

    protected void handleTextModifiedFromUi(Event event) {
        if (this.getUpdateSwtFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getSwtField().isVisible() && this.getSwtField().isFocusControl()) {
            String text = this.getSwtField().getText();
            if (text == null || text.length() == 0) {
                if (this.m_proposalPopup != null) {
                    this.requestProposalSupportFromSwt(text, false);
                } else {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ((IContentAssistField)SwtScoutSmartField.this.getScoutObject()).getUIFacade().setTextFromUI(null);
                        }
                    };
                    this.getEnvironment().invokeScoutLater(t, 0L);
                }
            } else {
                this.requestProposalSupportFromSwt(text, false);
            }
        }
    }

    protected void handleKeyDownFromUI(Event event) {
        switch (event.keyCode) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000005: 
            case 0x1000006: {
                if (!this.getSwtField().isEnabled() || !this.getSwtField().getEditable() || !this.getSwtField().isVisible()) break;
                if (this.m_proposalPopup == null) {
                    this.requestProposalSupportFromSwt("*", true);
                    break;
                }
                Table c = null;
                if (c == null) {
                    c = SwtUtility.findChildComponent((Widget)this.m_proposalPopup.getShellContentPane(), Table.class);
                }
                if (c == null) {
                    c = SwtUtility.findChildComponent((Widget)this.m_proposalPopup.getShellContentPane(), Tree.class);
                }
                SwtUtility.handleNavigationKey((Widget)c, event.keyCode);
            }
        }
    }

    protected void handleTraverseFromUi(Event event) {
        switch (event.keyCode) {
            case 27: {
                if (this.m_proposalPopup == null) break;
                event.doit = false;
            }
        }
    }

    private class P_F2KeyStroke
    extends SwtKeyStroke {
        public P_F2KeyStroke() {
            super(0x100000B);
        }

        @Override
        public void handleSwtAction(Event e) {
            SwtScoutSmartField.this.handleSwtBrowseAction();
        }
    }

    private class P_PendingProposalJob
    extends JobEx
    implements Runnable {
        private String m_text;
        private boolean m_selectCurrentValue;

        public P_PendingProposalJob() {
            super("");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            SwtScoutSmartField.this.getEnvironment().getDisplay().asyncExec((Runnable)this);
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = SwtScoutSmartField.this.m_pendingProposalJobLock;
            synchronized (object) {
                if (SwtScoutSmartField.this.m_pendingProposalJob != this) {
                    return;
                }
                SwtScoutSmartField.this.m_pendingProposalJob = null;
            }
            if (!SwtScoutSmartField.this.getSwtField().isDisposed() && SwtScoutSmartField.this.getSwtField().isFocusControl()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((IContentAssistField)SwtScoutSmartField.this.getScoutObject()).getUIFacade().openProposalFromUI(P_PendingProposalJob.this.m_text, P_PendingProposalJob.this.m_selectCurrentValue);
                    }
                };
                SwtScoutSmartField.this.getEnvironment().invokeScoutLater(t, 0L);
            }
        }

        public void update(String text, boolean selectCurrentValue) {
            this.m_text = text;
            this.m_selectCurrentValue = selectCurrentValue;
        }
    }

    private class P_UiFieldListener
    implements Listener {
        private P_UiFieldListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 24: {
                    SwtScoutSmartField.this.handleTextModifiedFromUi(event);
                    break;
                }
                case 1: {
                    SwtScoutSmartField.this.handleKeyDownFromUI(event);
                    break;
                }
                case 31: {
                    SwtScoutSmartField.this.handleTraverseFromUi(event);
                }
            }
        }
    }
}

