/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.sdk.ui.fields.FieldToolkit;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractStatusDialog
extends TitleAreaDialog {
    private IStatus m_status = Status.OK_STATUS;
    private IStatus m_defaultOkStatus = new Status(0, "org.eclipse.scout.sdk.ui", "");
    private final FieldToolkit m_fieldToolkit = new FieldToolkit();
    private int m_stateChangingCounter = 0;
    private String m_title;

    public AbstractStatusDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    public final void setMessage(String newMessage) {
        this.m_defaultOkStatus = new Status(this.m_defaultOkStatus.getSeverity(), this.m_defaultOkStatus.getPlugin(), newMessage);
        this.setStatus(this.m_status, this.m_defaultOkStatus);
    }

    public void create() {
        super.create();
        this.pingStateChanging();
        super.setTitle(this.getTitle());
    }

    protected boolean isControlCreated() {
        return this.getContents() != null && !this.getContents().isDisposed();
    }

    protected void pingStateChanging() {
        if (this.m_stateChangingCounter <= 0) {
            this.m_stateChangingCounter = 0;
            this.revalidate();
        }
    }

    protected void setStateChanging(boolean changing) {
        this.m_stateChangingCounter = changing ? ++this.m_stateChangingCounter : --this.m_stateChangingCounter;
        if (this.m_stateChangingCounter <= 0) {
            this.m_stateChangingCounter = 0;
            this.revalidate();
        }
    }

    protected final void revalidate() {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.scout.sdk.ui", -1, "multi status", null);
        this.validate(multiStatus);
        this.setStatus((IStatus)multiStatus, this.m_defaultOkStatus);
    }

    protected void validate(MultiStatus multiStatus) {
    }

    public void setStatus(IStatus status, IStatus defaultOkStatus) {
        int messagetype;
        IStatus highestSeverityStatus = this.getHighestSeverityStatus(status, defaultOkStatus);
        boolean okEnabled = true;
        switch (highestSeverityStatus.getSeverity()) {
            case 1: {
                messagetype = 1;
                break;
            }
            case 2: {
                messagetype = 2;
                break;
            }
            case 4: {
                messagetype = 3;
                okEnabled = false;
                break;
            }
            default: {
                messagetype = 0;
            }
        }
        String message = highestSeverityStatus.getMessage();
        if (this.isControlCreated()) {
            this.getButton(0).setEnabled(okEnabled);
            this.setMessage(message, messagetype);
        }
    }

    private IStatus getHighestSeverityStatus(IStatus status, IStatus highestSeverity) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                highestSeverity = this.getHighestSeverityStatus(child, highestSeverity);
                ++n2;
            }
            return highestSeverity;
        }
        if (highestSeverity.getSeverity() < status.getSeverity()) {
            highestSeverity = status;
        }
        return highestSeverity;
    }

    public FieldToolkit getFieldToolkit() {
        return this.m_fieldToolkit;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }
}

